"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTelemetry = exports.TelemetryContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _common = require("@kbn/stack-connectors-plugin/public/common");
var _types = require("../../services/telemetry/types");
var _use_kibana = require("../../common/hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/telemetry.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TelemetryContext = /*#__PURE__*/_react.default.createContext(null);
const useTelemetry = () => {
  const context = _react.default.useContext(TelemetryContext);
  if (!context) {
    throw new Error('useTelemetry must be used within a TelemetryContextProvider');
  }
  return context;
};
exports.useTelemetry = useTelemetry;
const TelemetryContextProvider = exports.TelemetryContextProvider = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const sessionData = (0, _react.useRef)({
    sessionId: (0, _uuid.v4)(),
    startedAt: Date.now()
  });
  const stepsData = (0, _react.useRef)({
    startedAt: Date.now()
  });
  const {
    telemetry
  } = (0, _use_kibana.useKibana)().services;
  const reportUploadZipIntegrationComplete = (0, _react.useCallback)(({
    integrationName,
    error
  }) => {
    telemetry.reportEvent(_types.TelemetryEventType.UploadIntegrationZipComplete, {
      integrationName,
      errorMessage: error
    });
  }, [telemetry]);
  const reportAssistantOpen = (0, _react.useCallback)(() => {
    const sessionId = (0, _uuid.v4)();
    sessionData.current = {
      sessionId,
      startedAt: Date.now()
    };
    stepsData.current = {
      startedAt: Date.now()
    };
    telemetry.reportEvent(_types.TelemetryEventType.AutomaticImportOpen, {
      sessionId
    });
  }, [telemetry]);
  const reportAssistantStepComplete = (0, _react.useCallback)(({
    step,
    stepName
  }) => {
    telemetry.reportEvent(_types.TelemetryEventType.AutomaticImportStepComplete, {
      sessionId: sessionData.current.sessionId,
      step,
      stepName,
      durationMs: Date.now() - stepsData.current.startedAt,
      sessionElapsedTime: Date.now() - sessionData.current.startedAt
    });
    stepsData.current = {
      startedAt: Date.now()
    };
  }, [telemetry]);
  const reportGenerationComplete = (0, _react.useCallback)(({
    connector,
    integrationSettings,
    durationMs,
    error
  }) => {
    var _integrationSettings$, _integrationSettings$2, _connector$apiProvide;
    telemetry.reportEvent(_types.TelemetryEventType.AutomaticImportGenerationComplete, {
      sessionId: sessionData.current.sessionId,
      sampleRows: (_integrationSettings$ = integrationSettings === null || integrationSettings === void 0 ? void 0 : (_integrationSettings$2 = integrationSettings.logSamples) === null || _integrationSettings$2 === void 0 ? void 0 : _integrationSettings$2.length) !== null && _integrationSettings$ !== void 0 ? _integrationSettings$ : 0,
      actionTypeId: connector.actionTypeId,
      model: getConnectorModel(connector),
      provider: (_connector$apiProvide = connector.apiProvider) !== null && _connector$apiProvide !== void 0 ? _connector$apiProvide : 'unknown',
      durationMs,
      errorMessage: error
    });
  }, [telemetry]);
  const reportCelGenerationComplete = (0, _react.useCallback)(({
    connector,
    integrationSettings,
    durationMs,
    error
  }) => {
    var _connector$apiProvide2;
    telemetry.reportEvent(_types.TelemetryEventType.AutomaticImportCelGenerationComplete, {
      sessionId: sessionData.current.sessionId,
      actionTypeId: connector.actionTypeId,
      model: getConnectorModel(connector),
      provider: (_connector$apiProvide2 = connector.apiProvider) !== null && _connector$apiProvide2 !== void 0 ? _connector$apiProvide2 : 'unknown',
      durationMs,
      errorMessage: error
    });
  }, [telemetry]);
  const reportAssistantComplete = (0, _react.useCallback)(({
    integrationName,
    integrationSettings,
    connector,
    error
  }) => {
    var _integrationSettings$3, _integrationSettings$4, _integrationSettings$5, _connector$apiProvide3;
    telemetry.reportEvent(_types.TelemetryEventType.AutomaticImportComplete, {
      sessionId: sessionData.current.sessionId,
      integrationName,
      integrationDescription: (_integrationSettings$3 = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.description) !== null && _integrationSettings$3 !== void 0 ? _integrationSettings$3 : 'unknown',
      dataStreamName: (_integrationSettings$4 = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.dataStreamName) !== null && _integrationSettings$4 !== void 0 ? _integrationSettings$4 : 'unknown',
      inputTypes: (_integrationSettings$5 = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.inputTypes) !== null && _integrationSettings$5 !== void 0 ? _integrationSettings$5 : ['unknown'],
      actionTypeId: connector.actionTypeId,
      model: getConnectorModel(connector),
      provider: (_connector$apiProvide3 = connector.apiProvider) !== null && _connector$apiProvide3 !== void 0 ? _connector$apiProvide3 : 'unknown',
      durationMs: Date.now() - sessionData.current.startedAt,
      errorMessage: error
    });
  }, [telemetry]);
  const value = (0, _react.useMemo)(() => ({
    reportUploadZipIntegrationComplete,
    reportAssistantOpen,
    reportAssistantStepComplete,
    reportGenerationComplete,
    reportCelGenerationComplete,
    reportAssistantComplete
  }), [reportUploadZipIntegrationComplete, reportAssistantOpen, reportAssistantStepComplete, reportGenerationComplete, reportCelGenerationComplete, reportAssistantComplete]);
  return /*#__PURE__*/_react.default.createElement(TelemetryContext.Provider, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 10
    }
  }, children);
});
TelemetryContextProvider.displayName = 'TelemetryContextProvider';
const getConnectorModel = connector => {
  let model = 'unknown';
  if (!connector.isPreconfigured) {
    var _config;
    const {
      apiUrl,
      defaultModel
    } = (_config = connector.config) !== null && _config !== void 0 ? _config : {};
    if (connector.apiProvider === _common.OpenAiProviderType.AzureAi) {
      var _getAzureModelFromPar;
      model = (_getAzureModelFromPar = getAzureModelFromParameter(apiUrl !== null && apiUrl !== void 0 ? apiUrl : '')) !== null && _getAzureModelFromPar !== void 0 ? _getAzureModelFromPar : 'unknown';
    } else {
      model = defaultModel !== null && defaultModel !== void 0 ? defaultModel : 'unknown';
    }
  }
  return model;
};
const getAzureModelFromParameter = url => {
  const urlSearchParams = new URLSearchParams(new URL(url).search);
  if (urlSearchParams.get('api-version')) {
    return `OpenAI version ${urlSearchParams.get('api-version')}`;
  }
  return undefined;
};