"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PACKAGE_UPLOAD_TITLE = exports.PACKAGE_UPLOAD_DESCRIPTION = exports.PACKAGE_UPLOAD_BUTTON = exports.LANDING_TITLE = exports.LANDING_DESCRIPTION = exports.AUTOMATIC_IMPORT_TITLE = exports.AUTOMATIC_IMPORT_DESCRIPTION = exports.AUTOMATIC_IMPORT_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LANDING_TITLE = exports.LANDING_TITLE = _i18n.i18n.translate('xpack.automaticImport.createIntegrationLanding.title', {
  defaultMessage: 'Create new integration'
});
const LANDING_DESCRIPTION = exports.LANDING_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.createIntegrationLanding.description', {
  defaultMessage: 'Start an AI-driven process to build your integration step-by-step, or upload a .zip package of a previously created integration'
});
const PACKAGE_UPLOAD_TITLE = exports.PACKAGE_UPLOAD_TITLE = _i18n.i18n.translate('xpack.automaticImport.createIntegrationLanding.packageUpload.title', {
  defaultMessage: 'Package upload'
});
const PACKAGE_UPLOAD_DESCRIPTION = exports.PACKAGE_UPLOAD_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.createIntegrationLanding.packageUpload.description', {
  defaultMessage: 'Use this option if you have an existing integration package in a .zip file'
});
const PACKAGE_UPLOAD_BUTTON = exports.PACKAGE_UPLOAD_BUTTON = _i18n.i18n.translate('xpack.automaticImport.createIntegrationLanding.packageUpload.button', {
  defaultMessage: 'Upload .zip'
});
const AUTOMATIC_IMPORT_TITLE = exports.AUTOMATIC_IMPORT_TITLE = _i18n.i18n.translate('xpack.automaticImport.createIntegrationLanding.assistant.title', {
  defaultMessage: 'Create custom integration'
});
const AUTOMATIC_IMPORT_DESCRIPTION = exports.AUTOMATIC_IMPORT_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.createIntegrationLanding.assistant.description', {
  defaultMessage: 'Use our AI-driven process to build your custom integration'
});
const AUTOMATIC_IMPORT_BUTTON = exports.AUTOMATIC_IMPORT_BUTTON = _i18n.i18n.translate('xpack.automaticImport.createIntegrationLanding.assistant.button', {
  defaultMessage: 'Create Integration'
});