"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSetup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var _use_load_action_types = require("@kbn/elastic-assistant/impl/connectorland/use_load_action_types");
var _use_kibana = require("../../../../../common/hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/steps/connector_step/connector_setup.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const usePanelCss = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react2.css)`
    &.euiPanel:hover {
      background-color: ${euiTheme.colors.lightestShade};
    }
  `;
};
const ConnectorSetup = exports.ConnectorSetup = /*#__PURE__*/_react.default.memo(({
  onConnectorSaved,
  onClose,
  actionTypeIds,
  compressed = false
}) => {
  const panelCss = usePanelCss();
  const {
    http,
    triggersActionsUi: {
      actionTypeRegistry
    },
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const [selectedActionType, setSelectedActionType] = (0, _react.useState)(null);
  const onModalClose = (0, _react.useCallback)(() => {
    setSelectedActionType(null);
    onClose === null || onClose === void 0 ? void 0 : onClose();
  }, [onClose]);
  const {
    data
  } = (0, _use_load_action_types.useLoadActionTypes)({
    http,
    toasts
  });
  const actionTypes = (0, _react.useMemo)(() => {
    if (actionTypeIds && data) {
      return data.filter(actionType => actionTypeIds.includes(actionType.id));
    }
    return data;
  }, [data, actionTypeIds]);
  if (!actionTypes) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, compressed ? /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    "data-test-subj": "connectorSetupCompressed",
    listItems: actionTypes.map(actionType => ({
      id: actionType.id,
      label: actionType.name,
      size: 's',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "l",
        color: "text",
        type: actionTypeRegistry.get(actionType.id).iconClass,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 17
        }
      }),
      isDisabled: !actionType.enabled,
      onClick: () => setSelectedActionType(actionType)
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "connectorSetupPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, actionTypes === null || actionTypes === void 0 ? void 0 : actionTypes.map(actionType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: actionType.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => setSelectedActionType(actionType),
    "data-test-subj": `actionType-${actionType.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    css: panelCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    color: "text",
    type: actionTypeRegistry.get(actionType.id).iconClass,
    "data-test-subj": "connectorActionId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "connectorActionName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 25
    }
  }, actionType.name)))))))), selectedActionType && /*#__PURE__*/_react.default.createElement(_constants.ConnectorAddModal, {
    actionTypeRegistry: actionTypeRegistry,
    actionType: selectedActionType,
    onClose: onModalClose,
    postSaveEventHandler: onConnectorSaved,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }));
});
ConnectorSetup.displayName = 'ConnectorSetup';