"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESS = exports.SPEC_FILE_REQUIRED = exports.OPEN_API_UPLOAD_INSTRUCTIONS = exports.GENERATION_ERROR = exports.DATASTREAM_TITLE_REQUIRED = exports.CANCEL = exports.API_DEFINITION_TITLE = exports.API_DEFINITION_ERROR = exports.API_DEFINITION_DESCRIPTION_2 = exports.API_DEFINITION_DESCRIPTION = exports.ANALYZING = exports.ANALYZE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_API_UPLOAD_INSTRUCTIONS = exports.OPEN_API_UPLOAD_INSTRUCTIONS = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.uploadInstructions', {
  defaultMessage: "The LLM will analyze the file to identify the structure of your API data. The OpenAPI spec file is typically found in the vendor's API reference documentation."
});
const API_DEFINITION_TITLE = exports.API_DEFINITION_TITLE = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.apiDefinition.title', {
  defaultMessage: 'Upload an OpenAPI spec file'
});
const API_DEFINITION_DESCRIPTION = exports.API_DEFINITION_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.apiDefinition.description', {
  defaultMessage: 'Drag and drop a file or browse files.'
});
const API_DEFINITION_DESCRIPTION_2 = exports.API_DEFINITION_DESCRIPTION_2 = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.apiDefinition.description2', {
  defaultMessage: 'OpenAPI specification'
});
const API_DEFINITION_ERROR = exports.API_DEFINITION_ERROR = {
  CAN_NOT_READ: _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.openapiSpec.errorCanNotRead', {
    defaultMessage: 'Failed to read the uploaded file'
  }),
  INVALID_OAS: _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.openapiSpec.errorInvalidFormat', {
    defaultMessage: 'Uploaded file is not a valid OpenApi spec file'
  }),
  CAN_NOT_READ_WITH_REASON: reason => _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.openapiSpec.errorCanNotReadWithReason', {
    values: {
      reason
    },
    defaultMessage: 'An error occurred when reading spec file: {reason}'
  }),
  TOO_LARGE_TO_PARSE: _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.openapiSpec.errorTooLargeToParse', {
    defaultMessage: 'This spec file is too large to parse'
  }),
  NO_PATHS_IDENTIFIED: _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.openapiSpec.noPathsIdentified', {
    defaultMessage: 'No valid paths found in OpenAPI spec file'
  })
};
const GENERATION_ERROR = exports.GENERATION_ERROR = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.generationError', {
  defaultMessage: 'An error occurred during API analysis'
});
const ANALYZE = exports.ANALYZE = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.analyze', {
  defaultMessage: 'Analyze'
});
const ANALYZING = exports.ANALYZING = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.analyzing', {
  defaultMessage: 'Analyzing'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.cancel', {
  defaultMessage: 'Cancel'
});
const SUCCESS = exports.SUCCESS = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.success', {
  defaultMessage: 'Success'
});
const DATASTREAM_TITLE_REQUIRED = exports.DATASTREAM_TITLE_REQUIRED = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.dataStreamRequired', {
  defaultMessage: 'A data stream title is required'
});
const SPEC_FILE_REQUIRED = exports.SPEC_FILE_REQUIRED = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.uploadSpec.specFileRequired', {
  defaultMessage: 'An OpenAPI spec file is required'
});