"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESS = exports.RECOMMENDED = exports.PATH_REQUIRED = exports.GENERATION_ERROR = exports.GENERATING = exports.GENERATE = exports.ENTER_MANUALLY = exports.CONFIRM_ENDPOINT_DESCRIPTION = exports.CONFIRM_ENDPOINT = exports.CONFIRM_AUTH_DESCRIPTION = exports.CONFIRM_AUTH = exports.CANCEL = exports.AUTH_SELECTION_TITLE = exports.AUTH_REQUIRED = exports.AUTH_DOES_NOT_ALIGN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RECOMMENDED = exports.RECOMMENDED = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.recommended', {
  defaultMessage: 'Recommended'
});
const ENTER_MANUALLY = exports.ENTER_MANUALLY = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.enterManually', {
  defaultMessage: 'Enter manually'
});
const CONFIRM_ENDPOINT = exports.CONFIRM_ENDPOINT = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.confirmEndpoint', {
  defaultMessage: 'Choose API endpoint'
});
const CONFIRM_ENDPOINT_DESCRIPTION = exports.CONFIRM_ENDPOINT_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.confirmEndpointDescription', {
  defaultMessage: 'Recommended API endpoints (chosen from your spec file):'
});
const CONFIRM_AUTH = exports.CONFIRM_AUTH = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.confirmAuth', {
  defaultMessage: 'Select Authentication method'
});
const CONFIRM_AUTH_DESCRIPTION = exports.CONFIRM_AUTH_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.confirmAuthDescription', {
  defaultMessage: 'Select the authentication method for the API endpoint. Generation should take less than a minute.'
});
const AUTH_SELECTION_TITLE = exports.AUTH_SELECTION_TITLE = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.authSelectionTitle', {
  defaultMessage: 'Preferred method'
});
const AUTH_DOES_NOT_ALIGN = exports.AUTH_DOES_NOT_ALIGN = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.authDoesNotAlign', {
  defaultMessage: 'This method does not align with your spec file'
});
const GENERATION_ERROR = exports.GENERATION_ERROR = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.generationError', {
  defaultMessage: 'An error occurred during: CEL input generation'
});
const GENERATE = exports.GENERATE = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.generateButtonLabel', {
  defaultMessage: 'Generate'
});
const GENERATING = exports.GENERATING = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.generatingButtonLabel', {
  defaultMessage: 'Generating'
});
const SUCCESS = exports.SUCCESS = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.success', {
  defaultMessage: 'Success! Configuration ready.'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.cancel', {
  defaultMessage: 'Cancel'
});
const PATH_REQUIRED = exports.PATH_REQUIRED = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.pathRequired', {
  defaultMessage: 'API endpoint is required'
});
const AUTH_REQUIRED = exports.AUTH_REQUIRED = _i18n.i18n.translate('xpack.automaticImport.celFlyout.step.confirmSettings.authRequired', {
  defaultMessage: 'Authentication method is required'
});