"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runRelatedGraph = exports.runInstallPackage = exports.runEcsGraph = exports.runCheckPipelineResults = exports.runCelGraph = exports.runCategorizationGraph = exports.runBuildIntegration = exports.runAnalyzeLogsGraph = exports.runAnalyzeApiGraph = exports.getInstalledPackages = void 0;
var _common = require("../../../common");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultHeaders = {
  'Elastic-Api-Version': '1'
};
const fleetDefaultHeaders = {
  'Elastic-Api-Version': '2023-10-31'
};
const runAnalyzeApiGraph = async (body, {
  http,
  abortSignal
}) => http.post(_constants.ANALYZE_API_PATH, {
  headers: defaultHeaders,
  body: JSON.stringify(body),
  signal: abortSignal
});
exports.runAnalyzeApiGraph = runAnalyzeApiGraph;
const runAnalyzeLogsGraph = async (body, {
  http,
  abortSignal
}) => http.post(_constants.ANALYZE_LOGS_PATH, {
  headers: defaultHeaders,
  body: JSON.stringify(body),
  signal: abortSignal
});
exports.runAnalyzeLogsGraph = runAnalyzeLogsGraph;
const runEcsGraph = async (body, {
  http,
  abortSignal
}) => http.post(_common.ECS_GRAPH_PATH, {
  headers: defaultHeaders,
  body: JSON.stringify(body),
  signal: abortSignal
});
exports.runEcsGraph = runEcsGraph;
const runCategorizationGraph = async (body, {
  http,
  abortSignal
}) => http.post(_common.CATEGORIZATION_GRAPH_PATH, {
  headers: defaultHeaders,
  body: JSON.stringify(body),
  signal: abortSignal
});
exports.runCategorizationGraph = runCategorizationGraph;
const runRelatedGraph = async (body, {
  http,
  abortSignal
}) => http.post(_common.RELATED_GRAPH_PATH, {
  headers: defaultHeaders,
  body: JSON.stringify(body),
  signal: abortSignal
});
exports.runRelatedGraph = runRelatedGraph;
const runCelGraph = async (body, {
  http,
  abortSignal
}) => http.post(_common.CEL_INPUT_GRAPH_PATH, {
  headers: defaultHeaders,
  body: JSON.stringify(body),
  signal: abortSignal
});
exports.runCelGraph = runCelGraph;
const runCheckPipelineResults = async (body, {
  http,
  abortSignal
}) => http.post(_common.CHECK_PIPELINE_PATH, {
  headers: defaultHeaders,
  body: JSON.stringify(body),
  signal: abortSignal
});
exports.runCheckPipelineResults = runCheckPipelineResults;
const runBuildIntegration = async (body, {
  http,
  abortSignal
}) => http.post(_common.INTEGRATION_BUILDER_PATH, {
  headers: defaultHeaders,
  body: JSON.stringify(body),
  signal: abortSignal
});
exports.runBuildIntegration = runBuildIntegration;
const runInstallPackage = async (zipFile, {
  http,
  abortSignal
}) => http.post(_constants.FLEET_PACKAGES_PATH, {
  headers: {
    ...fleetDefaultHeaders,
    Accept: 'application/zip',
    'Content-Type': 'application/zip'
  },
  body: zipFile,
  signal: abortSignal
});
exports.runInstallPackage = runInstallPackage;
const getInstalledPackages = async ({
  http,
  abortSignal
}) => http.get(_constants.FLEET_PACKAGES_PATH, {
  headers: fleetDefaultHeaders,
  query: {
    prerelease: true
  },
  signal: abortSignal
});
exports.getInstalledPackages = getInstalledPackages;