"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REQUIRED_PRIVILEGES = exports.PRIVILEGES_REQUIRED_TITLE = exports.PRIVILEGES_MISSING_TITLE = exports.CONTACT_ADMINISTRATOR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRIVILEGES_MISSING_TITLE = exports.PRIVILEGES_MISSING_TITLE = _i18n.i18n.translate('xpack.automaticImport.missingPrivileges.title', {
  defaultMessage: 'Missing privileges'
});
const PRIVILEGES_REQUIRED_TITLE = exports.PRIVILEGES_REQUIRED_TITLE = _i18n.i18n.translate('xpack.automaticImport.missingPrivileges.privilegesNeededTitle', {
  defaultMessage: 'The minimum Kibana privileges required to use this feature are:'
});
const REQUIRED_PRIVILEGES = exports.REQUIRED_PRIVILEGES = {
  FLEET_ALL: _i18n.i18n.translate('xpack.automaticImport.missingPrivileges.requiredPrivileges.fleet', {
    defaultMessage: 'Management > Fleet: All'
  }),
  INTEGRATIONS_ALL: _i18n.i18n.translate('xpack.automaticImport.missingPrivileges.requiredPrivileges.integrations', {
    defaultMessage: 'Management > Integrations: All'
  }),
  CONNECTORS_READ: _i18n.i18n.translate('xpack.automaticImport.missingPrivileges.requiredPrivileges.connectorsRead', {
    defaultMessage: 'Management > Connectors: Read'
  }),
  CONNECTORS_ALL: _i18n.i18n.translate('xpack.automaticImport.missingPrivileges.requiredPrivileges.connectorsAll', {
    defaultMessage: 'Management > Connectors: All'
  })
};
const CONTACT_ADMINISTRATOR = exports.CONTACT_ADMINISTRATOR = _i18n.i18n.translate('xpack.automaticImport.missingPrivileges.contactAdministrator', {
  defaultMessage: 'Contact your administrator for assistance.'
});