/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.apm_bundle_jsonpfunction=self.apm_bundle_jsonpfunction||[]).push([[7141],{25083:(e,n,a)=>{a.d(n,{wB:()=>F,QE:()=>q,_z:()=>B,HM:()=>H,yH:()=>K});var t=a(55907),r=a(75008);const i=r.i18n.translate("xpack.apm.tutorial.shared_clients.configure.commands.serviceNameHint",{defaultMessage:"The service name is the primary filter in the APM UI and is used to group errors and trace data together. Allowed characters are a-z, A-Z, 0-9, -, _, and space."}),s=r.i18n.translate("xpack.apm.tutorial.shared_clients.configure.commands.secretTokenHint",{defaultMessage:"Use if APM Server requires a secret token. Both the agent and APM Server must be configured with the same token. This ensures that only your agents can send data to your APM server."}),o=r.i18n.translate("xpack.apm.tutorial.shared_clients.configure.commands.serverUrlHint",{defaultMessage:"Set the custom APM Server URL (default: {defaultApmServerUrl}). The URL must be fully qualified, including protocol (http or https) and port.",values:{defaultApmServerUrl:"http://localhost:8200"}}),m=r.i18n.translate("xpack.apm.tutorial.shared_clients.configure.commands.serviceEnvironmentHint",{defaultMessage:'The name of the environment this service is deployed in, e.g., "production" or "staging". Environments allow you to easily filter data on a global level in the APM UI. It\'s important to be consistent when naming environments across agents.'}),l={apmServiceName:"Delastic.apm.service_name",secretToken:"Delastic.apm.secret_token",apmServerUrl:"Delastic.apm.server_url",apmEnvironment:"Delastic.apm.environment"},c={start:1,highlight:"",annotations:{2:i,3:s,4:o,5:m}},p=`java -javaagent:/path/to/elastic-apm-agent-<version>.jar \\\n-${l.apmServiceName}={{{apmServiceName}}} \\\n-${l.secretToken}={{{secretToken}}} \\\n-${l.apmServerUrl}={{{apmServerUrl}}} \\\n-${l.apmEnvironment}={{{apmEnvironment}}} \\\n-Delastic.apm.application_packages=org.example \\\n-jar {{{apmServiceName}}}.jar`,v={apmServiceName:"serviceName",secretToken:"secretToken",apmServerUrl:"serverUrl",apmEnvironment:"environment"},u={start:1,highlight:"3, 5, 7, 9",annotations:{3:`${i} ${r.i18n.translate("xpack.apm.tutorial.nodeClient.createConfig.commands.serviceName",{defaultMessage:"Overrides the service name in package.json."})}`,5:s,7:o,9:m}},d=`// ${r.i18n.translate("xpack.apm.tutorial.nodeClient.configure.commands.addThisToTheFileTopComment",{defaultMessage:"Add this to the very top of the first file loaded in your app"})}\nvar apm = require('elastic-apm-node').start({\n  ${v.apmServiceName}: '{{{apmServiceName}}}',\n\n  ${v.secretToken}: '{{{secretToken}}}',\n\n  ${v.apmServerUrl}: '{{{apmServerUrl}}}',\n\n  ${v.apmEnvironment}: '{{{apmEnvironment}}}'\n})`,g={apmServiceName:"SERVICE_NAME",secretToken:"SECRET_TOKEN",apmServerUrl:"SERVER_URL",apmEnvironment:"ENVIRONMENT"},S={start:1,highlight:"1-4, 7, 9, 11, 13, 16-19",annotations:{2:r.i18n.translate("xpack.apm.tutorial.djangoClient.configure.commands.addAgentComment",{defaultMessage:"Add the agent to installed apps"}),7:i,9:s,11:o,13:m,17:r.i18n.translate("xpack.apm.tutorial.djangoClient.configure.commands.addTracingMiddlewareComment",{defaultMessage:"Add our tracing middleware to send performance metrics"})}},f=`INSTALLED_APPS = (\n  'elasticapm.contrib.django',\n  # ...\n)\n\nELASTIC_APM = {\n  '${g.apmServiceName}': '{{{apmServiceName}}}',\n\n  '${g.secretToken}': '{{{secretToken}}}',\n\n  '${g.apmServerUrl}': '{{{apmServerUrl}}}',\n\n  '${g.apmEnvironment}': '{{{apmEnvironment}}}',\n}\n\nMIDDLEWARE = (\n  'elasticapm.contrib.django.middleware.TracingMiddleware',\n  #...\n)`,E={apmServiceName:"SERVICE_NAME",secretToken:"SECRET_TOKEN",apmServerUrl:"SERVER_URL",apmEnvironment:"ENVIRONMENT"},h={start:1,highlight:"2-4, 7-18",annotations:{9:i,11:s,13:o,15:m}},k=`# ${r.i18n.translate("xpack.apm.tutorial.flaskClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp = Flask(__name__)\napm = ElasticAPM(app)\n\n# ${r.i18n.translate("xpack.apm.tutorial.flaskClient.configure.commands.configureElasticApmComment",{defaultMessage:"Or use ELASTIC_APM in your application's settings"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp.config['ELASTIC_APM'] = {\n  '${E.apmServiceName}': '{{{apmServiceName}}}',\n\n  '${E.secretToken}': '{{{secretToken}}}',\n\n  '${E.apmServerUrl}': '{{{apmServerUrl}}}',\n\n  '${E.apmEnvironment}': '{{{apmEnvironment}}}',\n}\n\napm = ElasticAPM(app)`,T={apmServiceName:"service_name",secretToken:"secret_token",apmServerUrl:"server_url",apmEnvironment:"environment"},N={start:1,highlight:"3, 5, 7, 9",annotations:{3:`${i} ${r.i18n.translate("xpack.apm.tutorial.railsClient.createConfig.commands.defaultServiceName",{defaultMessage:"Defaults to the name of your Rails app."})}`,5:s,7:o,9:m}},$=`# config/elastic_apm.yml:\n\n${T.apmServiceName}: '{{{apmServiceName}}}'\n\n${T.secretToken}: '{{{secretToken}}}'\n\n${T.apmServerUrl}: '{{{apmServerUrl}}}'\n\n${T.apmEnvironment}: '{{{apmEnvironment}}}'`,_={apmServiceName:"service_name",secretToken:"secret_token",apmServerUrl:"server_url",apmEnvironment:"environment"},C={start:1,highlight:"3, 5, 7, 9",annotations:{3:`${i} ${r.i18n.translate("xpack.apm.tutorial.rackClient.createConfig.commands.defaultsToTheNameOfRackAppClassComment",{defaultMessage:"Defaults to the name of your Rack app's class."})}`,5:s,7:o,9:m}},A=`# config/elastic_apm.yml:\n\n${_.apmServiceName}: '{{{apmServiceName}}}'\n\n${_.secretToken}: '{{{secretToken}}}'\n\n${_.apmServerUrl}: '{{{apmServerUrl}}}',\n\n${_.apmEnvironment}: '{{{apmEnvironment}}}'`,U={apmServiceName:"ELASTIC_APM_SERVICE_NAME",secretToken:"ELASTIC_APM_SECRET_TOKEN",apmServerUrl:"ELASTIC_APM_SERVER_URL",apmEnvironment:"ELASTIC_APM_ENVIRONMENT"},M={start:1,highlight:"2, 4, 6, 8",annotations:{2:`${i} ${r.i18n.translate("xpack.apm.tutorial.goClient.configure.commands.usedExecutableNameComment",{defaultMessage:"If not specified, the executable name will be used."})}`,4:s,6:o,8:m}},j=`# ${r.i18n.translate("xpack.apm.tutorial.goClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables:"})}\nexport ${U.apmServiceName}={{{apmServiceName}}}\n\nexport ${U.secretToken}={{{secretToken}}}\n\nexport ${U.apmServerUrl}={{{apmServerUrl}}}\n\nexport ${U.apmEnvironment}={{{apmEnvironment}}}\n`,x={apmServiceName:"ServiceName",secretToken:"SecretToken",apmServerUrl:"ServerUrl",apmEnvironment:"Environment"},b={start:1,highlight:"3, 4, 5, 6",annotations:{3:`${i} ${r.i18n.translate("xpack.apm.tutorial.dotnetClient.createConfig.commands.defaultServiceName",{defaultMessage:"Default is the entry assembly of the application."})}`,4:s,5:o,6:m}},y=`{\n  "ElasticApm": {\n    "${x.apmServiceName}": "{{{apmServiceName}}}",\n    "${x.secretToken}": "{{{secretToken}}}",\n    "${x.apmServerUrl}": "{{{apmServerUrl}}}",\n    "${x.apmEnvironment}": "{{{apmEnvironment}}}",\n  }\n}`,I={apmServiceName:"elastic_apm.service_name",secretToken:"elastic_apm.secret_token",apmServerUrl:"elastic_apm.server_url",apmEnvironment:"elastic_apm.environment"},R={start:1,highlight:"1, 3, 5, 7",annotations:{1:i,3:s,5:o,7:m}},P=`${I.apmServiceName}="{{{apmServiceName}}}"\n\n${I.secretToken}="{{{secretToken}}}"\n\n${I.apmServerUrl}="{{{apmServerUrl}}}"\n\n${I.apmEnvironment}="{{{apmEnvironment}}}"`,L={apmServiceName:"serviceName",apmServerUrl:"serverUrl",apmServiceVersion:"serviceVersion",apmEnvironment:"environment"},w=r.i18n.translate("xpack.apm.tutorial.jsClient.installDependency.commands.setServiceVersionComment",{defaultMessage:"Set the service version (required for source map feature)"}),V={java:p,node:d,django:f,flask:k,rails:$,rack:A,go:j,dotnet:y,php:P,js:`import { init as initApm } from '@elastic/apm-rum'\nvar apm = initApm({\n  ${L.apmServiceName}: '{{{apmServiceName}}}',\n\n  ${L.apmServerUrl}: '{{{apmServerUrl}}}',\n\n  serviceVersion: '',\n\n  ${L.apmEnvironment}: '{{{apmEnvironment}}}'\n})`,js_script:`<script src="https://your-cdn-host.com/path/to/elastic-apm-rum.umd.min.js" crossorigin><\/script>\n<script>\n  elasticApm.init({\n    ${L.apmServiceName}: '{{{apmServiceName}}}',\n    ${L.apmServerUrl}: '{{{apmServerUrl}}}',\n  })\n<\/script>\n`},D={java:l,node:v,django:g,flask:E,rails:T,rack:_,go:U,dotnet:x,php:I,js:L},O={java:c,node:u,django:S,flask:h,rails:N,rack:C,go:M,dotnet:b,php:R,js:{start:1,highlight:"3, 5, 7, 9",annotations:{3:i,5:o,7:w,9:m}}},z={java:"java",node:"js",django:"py",flask:"py",rails:"rb",rack:"rb",go:"go",dotnet:"dotnet",php:"php",js:"js"};function F({variantId:e,policyDetails:n,defaultValues:a}){const r=V[e];return r?t.A.render(r,{...n,...a}):""}function H(e){return D[e]}function B(e){return O[e]}function q(e){return z[e]}const K=[g.secretToken,x.secretToken,E.secretToken,U.secretToken,l.secretToken,v.secretToken,I.secretToken,_.secretToken,T.secretToken]},47787:(e,n,a)=>{a.d(n,{I:()=>m});var t=a(84286),r=a.n(t),i=a(81319),s=a(75008),o=a(96791);function m({variantId:e,lineNumbers:n,highlightLang:a,commands:t,commandsWithSecrets:m}){return(0,o.jsx)(r().Fragment,null,(0,o.jsx)(i.EuiCallOut,{title:s.i18n.translate("xpack.apm.onboarding.agentConfigInstructions.callout.title",{defaultMessage:"The command below doesn't show secrets values"}),color:"warning",iconType:"warning"},(0,o.jsx)("p",null,s.i18n.translate("xpack.apm.onboarding.agentConfigInstructions.callout.body",{defaultMessage:"Copy to clipboard to get the full command with secrets"}))),(0,o.jsx)(i.EuiSpacer,{size:"s"}),(0,o.jsx)(i.EuiPanel,{color:"subdued",borderRadius:"none",hasShadow:!1},(0,o.jsx)(i.EuiFlexGroup,{direction:"row"},(0,o.jsx)(i.EuiFlexItem,null,(0,o.jsx)(i.EuiCodeBlock,{copyAriaLabel:s.i18n.translate("xpack.apm.tutorial.apmAgents.agentConfigurationInstructions.copyAriaLabel",{defaultMessage:"Copy {variantId} agent configuration code",values:{variantId:e}}),language:a||"bash","data-test-subj":"commands",lineNumbers:n},t)),(0,o.jsx)(i.EuiFlexItem,{grow:!1},(0,o.jsx)(i.EuiButtonEmpty,{"data-test-subj":"apmAgentConfigInstructionsButton","aria-label":s.i18n.translate("xpack.apm.agentConfigInstructions.button.ariaLabel",{defaultMessage:"Copy commands"}),iconType:"copyClipboard",onClick:()=>{(0,i.copyToClipboard)(m)}})))))}}}]);