"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDerivedServiceAnnotations = getDerivedServiceAnnotations;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _maybe2 = require("../../../../common/utils/maybe");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _is_finite_number = require("../../../../common/utils/is_finite_number");
var _annotations = require("../../../../common/annotations");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _transactions = require("../../../lib/helpers/transactions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDerivedServiceAnnotations({
  apmEventClient,
  serviceName,
  environment,
  searchAggregatedTransactions,
  start,
  end
}) {
  var _await$apmEventClient, _await$apmEventClient2;
  const filter = [{
    term: {
      [_apm.SERVICE_NAME]: serviceName
    }
  }, ...(0, _transactions.getBackwardCompatibleDocumentTypeFilter)(searchAggregatedTransactions), ...(0, _environment_query.environmentQuery)(environment)];
  const versions = (_await$apmEventClient = (_await$apmEventClient2 = (await apmEventClient.search('get_derived_service_annotations', {
    apm: {
      events: [(0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions)]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [...filter, ...(0, _server.rangeQuery)(start, end)]
      }
    },
    aggs: {
      versions: {
        terms: {
          field: _apm.SERVICE_VERSION
        }
      }
    }
  })).aggregations) === null || _await$apmEventClient2 === void 0 ? void 0 : _await$apmEventClient2.versions.buckets.map(bucket => bucket.key)) !== null && _await$apmEventClient !== void 0 ? _await$apmEventClient : [];
  if (versions.length <= 1) {
    return [];
  }
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.AT_TIMESTAMP]);
  const annotations = await Promise.all(versions.map(async version => {
    var _maybe;
    const response = await apmEventClient.search('get_first_seen_of_version', {
      apm: {
        events: [(0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions)]
      },
      track_total_hits: false,
      size: 1,
      query: {
        bool: {
          filter: [...filter, {
            term: {
              [_apm.SERVICE_VERSION]: version
            }
          }]
        }
      },
      sort: {
        '@timestamp': 'asc'
      },
      fields: requiredFields
    });
    const event = (0, _utils.unflattenKnownApmEventFields)((_maybe = (0, _maybe2.maybe)(response.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields, requiredFields);
    const timestamp = event === null || event === void 0 ? void 0 : event[_apm.AT_TIMESTAMP];
    if (!timestamp) {
      throw new Error('First seen for version was unexpectedly undefined or null.');
    }
    const firstSeen = new Date(timestamp).getTime();
    if (!(0, _is_finite_number.isFiniteNumber)(firstSeen)) {
      throw new Error('First seen for version was unexpectedly undefined or null.');
    }
    if (firstSeen < start || firstSeen > end) {
      return null;
    }
    return {
      type: _annotations.AnnotationType.VERSION,
      id: version,
      [_apm.AT_TIMESTAMP]: firstSeen,
      text: version
    };
  }));
  return annotations.filter(Boolean);
}