"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSessionsByLocation = getSessionsByLocation;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _get_offset_in_ms = require("../../../common/utils/get_offset_in_ms");
var _get_bucket_size = require("../../../common/utils/get_bucket_size");
var _document_type = require("../../../common/document_type");
var _rollup = require("../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getSessionsByLocation({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  locationField,
  offset
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5, _response$aggregation6, _response$aggregation7, _response$aggregation8, _response$aggregation9, _response$aggregation10;
  const {
    startWithOffset,
    endWithOffset
  } = (0, _get_offset_in_ms.getOffsetInMs)({
    start,
    end,
    offset
  });
  const {
    intervalString
  } = (0, _get_bucket_size.getBucketSize)({
    start: startWithOffset,
    end: endWithOffset,
    minBucketSize: 60
  });
  const aggs = {
    sessions: {
      terms: {
        field: locationField
      },
      aggs: {
        sessions: {
          cardinality: {
            field: _apm.SESSION_ID
          }
        }
      }
    }
  };
  const response = await apmEventClient.search('get_mobile_location_sessions', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.TransactionEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.rangeQuery)(startWithOffset, endWithOffset), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
      }
    },
    aggs: {
      timeseries: {
        date_histogram: {
          field: '@timestamp',
          fixed_interval: intervalString,
          min_doc_count: 0
        },
        aggs
      },
      ...aggs
    }
  });
  return {
    location: (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : (_response$aggregation2 = _response$aggregation.sessions) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.buckets[0]) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.key,
    value: (_response$aggregation4 = (_response$aggregation5 = response.aggregations) === null || _response$aggregation5 === void 0 ? void 0 : (_response$aggregation6 = _response$aggregation5.sessions) === null || _response$aggregation6 === void 0 ? void 0 : (_response$aggregation7 = _response$aggregation6.buckets[0]) === null || _response$aggregation7 === void 0 ? void 0 : _response$aggregation7.sessions.value) !== null && _response$aggregation4 !== void 0 ? _response$aggregation4 : 0,
    timeseries: (_response$aggregation8 = (_response$aggregation9 = response.aggregations) === null || _response$aggregation9 === void 0 ? void 0 : (_response$aggregation10 = _response$aggregation9.timeseries) === null || _response$aggregation10 === void 0 ? void 0 : _response$aggregation10.buckets.map(bucket => {
      var _bucket$sessions$buck, _bucket$sessions$buck2;
      return {
        x: bucket.key,
        y: (_bucket$sessions$buck = (_bucket$sessions$buck2 = bucket.sessions.buckets[0]) === null || _bucket$sessions$buck2 === void 0 ? void 0 : _bucket$sessions$buck2.sessions.value) !== null && _bucket$sessions$buck !== void 0 ? _bucket$sessions$buck : 0
      };
    })) !== null && _response$aggregation8 !== void 0 ? _response$aggregation8 : []
  };
}