"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiagnosticsPrivileges = getDiagnosticsPrivileges;
var _get_indices = require("../bundle/get_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDiagnosticsPrivileges({
  esClient,
  apmIndices
}) {
  const indexPatterns = (0, _get_indices.getApmIndexPatterns)([apmIndices.error, apmIndices.metric, apmIndices.span, apmIndices.transaction]);
  const clusterPrivileges = ['manage_index_templates', 'monitor', 'read_pipeline'];
  const {
    index,
    cluster
  } = await esClient.security.hasPrivileges({
    index: [{
      names: indexPatterns,
      privileges: ['read']
    }],
    cluster: clusterPrivileges
  });
  const hasAllIndexPrivileges = Object.values(index).every(indexPrivs => Object.values(indexPrivs).every(priv => priv));
  const hasAllClusterPrivileges = Object.values(cluster).every(priv => priv);
  return {
    index,
    cluster,
    hasAllIndexPrivileges,
    hasAllClusterPrivileges,
    hasAllPrivileges: hasAllIndexPrivileges && hasAllClusterPrivileges
  };
}