"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmEvents = getApmEvents;
var _server = require("@kbn/observability-plugin/server");
var _lodash = require("lodash");
var _apm = require("../../../../common/es_fields/apm");
var _get_indices = require("./get_indices");
var _create_typed_es_client = require("../../../utils/create_typed_es_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmEvents({
  esClient,
  apmIndices,
  start,
  end,
  kuery
}) {
  const typedSearch = (0, _create_typed_es_client.getTypedSearch)(esClient);
  const commonProps = {
    start,
    end,
    typedSearch
  };
  const items = await Promise.all([getEventWithMetricsetInterval({
    ...commonProps,
    name: 'Metric: Service destination',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.metric]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "metric" AND ${_apm.METRICSET_NAME}: "service_destination"`, kuery)
  }), getEventWithMetricsetInterval({
    ...commonProps,
    name: 'Metric: Service transaction (8.7+)',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.metric]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "metric" AND ${_apm.METRICSET_NAME}: "service_transaction" AND ${_apm.TRANSACTION_DURATION_SUMMARY} :* `, kuery)
  }), getEventWithMetricsetInterval({
    ...commonProps,
    name: 'Metric: Transaction (8.7+)',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.metric]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "metric" AND ${_apm.METRICSET_NAME}: "transaction" AND ${_apm.TRANSACTION_DURATION_SUMMARY} :* `, kuery)
  }), getEventWithMetricsetInterval({
    ...commonProps,
    legacy: true,
    name: 'Metric: Service transaction (pre-8.7)',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.metric]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "metric" AND ${_apm.METRICSET_NAME}: "service_transaction" AND not ${_apm.TRANSACTION_DURATION_SUMMARY} :* `, kuery)
  }), getEventWithMetricsetInterval({
    ...commonProps,
    legacy: true,
    name: 'Metric: Transaction (pre-8.7)',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.metric]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "metric" AND ${_apm.METRICSET_NAME}: "transaction" AND not ${_apm.TRANSACTION_DURATION_SUMMARY} :* `, kuery)
  }), getEventWithMetricsetInterval({
    ...commonProps,
    name: 'Metric: Service summary',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.metric]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "metric" AND ${_apm.METRICSET_NAME}: "service_summary"`, kuery)
  }), getEvent({
    ...commonProps,
    name: 'Metric: Span breakdown',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.metric]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "metric" AND ${_apm.METRICSET_NAME}: "span_breakdown"`, kuery)
  }), getEvent({
    ...commonProps,
    name: 'Event: Transaction',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.transaction]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "transaction"`, kuery)
  }), getEvent({
    ...commonProps,
    name: 'Event: Span',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.span]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "span"`, kuery)
  }), getEvent({
    ...commonProps,
    name: 'Event: Error',
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.error]),
    kuery: mergeKueries(`${_apm.PROCESSOR_EVENT}: "error"`, kuery)
  })]);
  return items;
}
async function getEventWithMetricsetInterval({
  legacy,
  name,
  index,
  start,
  end,
  kuery,
  typedSearch
}) {
  var _res$aggregations;
  const res = await typedSearch({
    expand_wildcards: 'all',
    track_total_hits: true,
    index,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.kqlQuery)(kuery), ...(0, _server.rangeQuery)(start, end)]
      }
    },
    aggs: {
      metricset_intervals: {
        terms: {
          size: 1000,
          field: _apm.METRICSET_INTERVAL
        },
        aggs: {
          metric_doc_count: {
            value_count: {
              field: _apm.INDEX
            }
          }
        }
      }
    }
  });
  const defaultIntervals = {
    '1m': {
      metricDocCount: 0,
      eventDocCount: 0
    },
    '10m': {
      metricDocCount: 0,
      eventDocCount: 0
    },
    '60m': {
      metricDocCount: 0,
      eventDocCount: 0
    }
  };
  const foundIntervals = (_res$aggregations = res.aggregations) === null || _res$aggregations === void 0 ? void 0 : _res$aggregations.metricset_intervals.buckets.reduce((acc, item) => {
    acc[item.key] = {
      metricDocCount: item.metric_doc_count.value,
      eventDocCount: item.doc_count
    };
    return acc;
  }, {});
  const intervals = (0, _lodash.merge)(defaultIntervals, foundIntervals);
  return {
    legacy,
    name,
    kuery,
    index,
    docCount: res.hits.total.value,
    intervals
  };
}
async function getEvent({
  name,
  index,
  start,
  end,
  kuery,
  typedSearch
}) {
  const res = await typedSearch({
    track_total_hits: true,
    index,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.kqlQuery)(kuery), ...(0, _server.rangeQuery)(start, end)]
      }
    }
  });
  return {
    name,
    kuery,
    index,
    docCount: res.hits.total.value
  };
}
function mergeKueries(fixedKuery, kuery) {
  if (!kuery) {
    return fixedKuery;
  }
  return `(${fixedKuery}) AND (${kuery})`;
}