"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUrl = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildUrl = item => {
  var _item$url, _item$url2, _item$server, _item$server2;
  // URL fields from Otel
  const urlScheme = item === null || item === void 0 ? void 0 : (_item$url = item.url) === null || _item$url === void 0 ? void 0 : _item$url.scheme;
  const urlPath = item === null || item === void 0 ? void 0 : (_item$url2 = item.url) === null || _item$url2 === void 0 ? void 0 : _item$url2.path;
  const serverAddress = item === null || item === void 0 ? void 0 : (_item$server = item.server) === null || _item$server === void 0 ? void 0 : _item$server.address;
  const serverPort = item === null || item === void 0 ? void 0 : (_item$server2 = item.server) === null || _item$server2 === void 0 ? void 0 : _item$server2.port;
  const hasURLFromFields = urlScheme && serverAddress;
  const urlServerPort = serverPort ? `:${serverPort}` : '';
  try {
    const url = hasURLFromFields ? new URL(urlPath !== null && urlPath !== void 0 ? urlPath : '', `${urlScheme}://${serverAddress}${urlServerPort}`).toString() : undefined;
    return url;
  } catch (e) {
    console.error('Failed to build URL', e);
    return undefined;
  }
};
exports.buildUrl = buildUrl;