"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSearchBar = TableSearchBar;
exports.getItemsFilteredBySearchQuery = getItemsFilteredBySearchQuery;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _technical_preview_badge = require("../technical_preview_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/table_search_bar/table_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TableSearchBar({
  placeholder,
  searchQuery,
  onChangeSearchQuery,
  isLoading,
  techPreview = false
}) {
  const debouncedSearchQuery = (0, _react.useMemo)(() => (0, _lodash.debounce)(onChangeSearchQuery, 500), [onChangeSearchQuery]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, techPreview ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            justify-content: center;
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    icon: "beaker",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "tableSearchInput",
    placeholder: placeholder,
    fullWidth: true,
    defaultValue: searchQuery,
    compressed: true,
    isLoading: isLoading,
    onChange: e => {
      debouncedSearchQuery(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })));
}
function getItemsFilteredBySearchQuery({
  items,
  fieldsToSearch,
  searchQuery
}) {
  const query = searchQuery.toLowerCase();
  return items.filter(item => {
    return fieldsToSearch.some(field => {
      const fieldValue = item[field];
      return fieldValue === null || fieldValue === void 0 ? void 0 : fieldValue.toLowerCase().includes(query);
    });
  });
}