"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartContainer = ChartContainer;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/chart_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ChartContainer({
  children,
  height,
  status,
  hasData,
  id
}) {
  if (!hasData && (0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement(LoadingChartPlaceholder, {
      height: height,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 12
      }
    });
  }
  if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return /*#__PURE__*/_react.default.createElement(FailedChartPlaceholder, {
      height: height,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height
    },
    "data-test-subj": id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, children);
}
function LoadingChartPlaceholder({
  height
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height,
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    "data-test-subj": "loading",
    size: 'xl',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
}
function FailedChartPlaceholder({
  height
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    style: {
      height
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.chart.error', {
    defaultMessage: 'An error happened when trying to fetch data. Please try again'
  }));
}