"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmHeaderActionMenu = ApmHeaderActionMenu;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _get_alerting_capabilities = require("../../../alerting/utils/get_alerting_capabilities");
var _apm_link_hooks = require("../../../shared/links/apm/apm_link_hooks");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _alerting_popover_flyout = require("./alerting_popover_flyout");
var _inspector_header_link = require("./inspector_header_link");
var _give_feedback_header_link = require("./give_feedback_header_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/app_root/apm_header_action_menu/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApmHeaderActionMenu() {
  var _capabilities$ml, _onboardingLocator$us;
  const {
    core,
    plugins,
    config,
    share
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    search
  } = window.location;
  const {
    application,
    http
  } = core;
  const {
    basePath
  } = http;
  const {
    capabilities
  } = application;
  const {
    featureFlags
  } = config;
  const canReadMlJobs = !!((_capabilities$ml = capabilities.ml) !== null && _capabilities$ml !== void 0 && _capabilities$ml.canGetJobs);
  const {
    isAlertingAvailable,
    canReadAlerts,
    canSaveAlerts
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(plugins, capabilities);
  const canSaveApmAlerts = capabilities.apm.save && canSaveAlerts;
  const onboardingLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const addDataUrl = (_onboardingLocator$us = onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.useUrl({
    category: 'application'
  })) !== null && _onboardingLocator$us !== void 0 ? _onboardingLocator$us : '';
  function apmHref(path) {
    return (0, _apm_link_hooks.getLegacyApmHref)({
      basePath,
      path,
      search
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_give_feedback_header_link.GiveFeedbackHeaderLink, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), featureFlags.storageExplorerAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: apmHref('/storage-explorer'),
    "data-test-subj": "apmStorageExplorerHeaderLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorerLinkLabel', {
    defaultMessage: 'Storage explorer'
  })))), isAlertingAvailable && /*#__PURE__*/_react.default.createElement(_alerting_popover_flyout.AlertingPopoverAndFlyout, {
    canReadAlerts: canReadAlerts,
    canSaveAlerts: canSaveApmAlerts,
    canReadMlJobs: canReadMlJobs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: apmHref('/settings'),
    "data-test-subj": "apmSettingsHeaderLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.settingsLinkLabel', {
    defaultMessage: 'Settings'
  })), /*#__PURE__*/_react.default.createElement(_inspector_header_link.InspectorHeaderLink, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: addDataUrl,
    "data-test-subj": "apmAddDataHeaderLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.addDataButtonLabel', {
    defaultMessage: 'Add data'
  })));
}