"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REQUIRED_LABEL = exports.OPTIONAL_LABEL = void 0;
exports.isSettingsFormValid = isSettingsFormValid;
exports.mergeNewVars = mergeNewVars;
exports.validateSettingValue = validateSettingValue;
var _i18n = require("@kbn/i18n");
var _Either = require("fp-ts/Either");
var _PathReporter = require("io-ts/lib/PathReporter");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REQUIRED_LABEL = exports.REQUIRED_LABEL = _i18n.i18n.translate('xpack.apm.fleet_integration.settings.requiredLabel', {
  defaultMessage: 'Required'
});
const OPTIONAL_LABEL = exports.OPTIONAL_LABEL = _i18n.i18n.translate('xpack.apm.fleet_integration.settings.optionalLabel', {
  defaultMessage: 'Optional'
});
const REQUIRED_FIELD = _i18n.i18n.translate('xpack.apm.fleet_integration.settings.requiredFieldLabel', {
  defaultMessage: 'Required field'
});
function mergeNewVars(oldVars, key, value) {
  return {
    ...oldVars,
    [key]: {
      ...oldVars[key],
      value
    }
  };
}
function isSettingsFormValid(parentSettings, vars) {
  function isSettingsValid(settings) {
    return !settings.map(setting => {
      var _vars$setting$key;
      if (setting.type === 'advanced_setting') {
        return isSettingsValid(setting.settings);
      }
      if (setting.settings) {
        return isSettingsValid(setting.settings);
      }
      const {
        isValid
      } = validateSettingValue(setting, (_vars$setting$key = vars[setting.key]) === null || _vars$setting$key === void 0 ? void 0 : _vars$setting$key.value);
      return isValid;
    }).flat().some(isValid => !isValid);
  }
  return isSettingsValid(parentSettings);
}
function validateSettingValue(setting, value) {
  if (!(0, _lodash.isFinite)(value) && (0, _lodash.isEmpty)(value)) {
    return {
      isValid: !setting.required,
      message: REQUIRED_FIELD
    };
  }
  if (setting.validation) {
    const result = setting.validation.decode(String(value));
    const message = _PathReporter.PathReporter.report(result)[0];
    const isValid = (0, _Either.isRight)(result);
    return {
      isValid,
      message
    };
  }
  return {
    isValid: true,
    message: ''
  };
}