"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrphanTraceItemsWarning = OrphanTraceItemsWarning;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/orphan_trace_items_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OrphanTraceItemsWarning({
  orphanTraceItemsCount
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: _i18n.i18n.translate('xpack.apm.transactionDetails.agentMissingTransactionMessage', {
      defaultMessage: 'This trace is incomplete and {itemsCount} items could not be displayed in the timeline. This could be a temporary problem caused by ingest delay, or a permanent problem caused by some events being dropped.',
      values: {
        itemsCount: orphanTraceItemsCount
      }
    }),
    anchorClassName: "eui-fullWidth",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    iconType: "warning",
    color: "hollow",
    "data-test-id": "apm-missing-transaction-badge",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.agentMissingTransactionLabel', {
    defaultMessage: 'Incomplete trace'
  })));
}