"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.iconForNode = iconForNode;
var _customIcons = require("@kbn/custom-icons");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _apm = require("../../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function iconForNode(node, isDarkMode = false) {
  const agentName = node.data(_apm.AGENT_NAME);
  const subtype = node.data(_apm.SPAN_SUBTYPE);
  const type = node.data(_apm.SPAN_TYPE);
  return agentName ? (0, _customIcons.getAgentIcon)(agentName, isDarkMode) : (0, _apmUiShared.getSpanIcon)(type, subtype);
}