"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupsList = ServiceGroupsList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _service_groups_list = require("./service_groups_list");
var _sort = require("./sort");
var _refresh_service_groups_subscriber = require("../refresh_service_groups_subscriber");
var _service_group_save = require("../service_group_save");
var _beta_badge = require("../../../shared/beta_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_groups_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServiceGroupsList() {
  const [filter, setFilter] = (0, _react.useState)('');
  const [apmServiceGroupsSortType, setServiceGroupsSortType] = (0, _react.useState)('recently_added');
  const {
    data = {
      serviceGroups: []
    },
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /internal/apm/service-groups'), []);
  const {
    serviceGroups
  } = data;
  const {
    data: servicesGroupCounts = {},
    status: statsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceGroups.length) {
      return callApmApi('GET /internal/apm/service-group/counts');
    }
  }, [serviceGroups.length]);
  const isLoading = (0, _use_fetcher.isPending)(status);
  const isLoadingStats = (0, _use_fetcher.isPending)(statsStatus);
  const filteredItems = (0, _lodash.isEmpty)(filter) ? serviceGroups : serviceGroups.filter(item => item.groupName.toLowerCase().includes(filter.toLowerCase()));
  const sortedItems = (0, _lodash.sortBy)(filteredItems, item => apmServiceGroupsSortType === 'alphabetical' ? item.groupName.toLowerCase() : item.updatedAt);
  const items = apmServiceGroupsSortType === 'recently_added' ? sortedItems.reverse() : sortedItems;
  const clearFilterCallback = (0, _react.useCallback)(() => {
    setFilter('');
  }, []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoObservability",
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.apm.servicesGroups.loadingServiceGroups', {
        defaultMessage: 'Loading service groups'
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_refresh_service_groups_subscriber.RefreshServiceGroupsSubscriber, {
    onRefresh: refetch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    css: {
      blockSize: 'auto'
    },
    clear: !(0, _lodash.isEmpty)(filter) ? {
      onClick: clearFilterCallback
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    controlOnly: true,
    compressed: true,
    "data-test-subj": "apmServiceGroupsListFieldText",
    icon: "search",
    fullWidth: true,
    value: filter,
    onChange: e => setFilter(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.apm.servicesGroups.filter', {
      defaultMessage: 'Filter groups'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sort.Sort, {
    type: apmServiceGroupsSortType,
    onChange: setServiceGroupsSortType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, serviceGroups.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      fontWeight: 'bold'
    },
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 27
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupsCount', {
    defaultMessage: '{servicesCount} {servicesCount, plural, =0 {groups} one {group} other {groups}}',
    values: {
      servicesCount: filteredItems.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.listDescription', {
    defaultMessage: 'Displayed service counts reflect the last 24 hours.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_service_group_save.ServiceGroupSaveButton, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 23
    }
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmServiceGroupsListGiveFeedbackLink",
    href: "https://ela.st/feedback-service-groups",
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.beta.feedback.link', {
    defaultMessage: 'Give feedback'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, serviceGroups.length ? items.length ? /*#__PURE__*/_react.default.createElement(_service_groups_list.ServiceGroupsListItems, {
    items: items,
    serviceGroupCounts: servicesGroupCounts,
    isLoading: isLoadingStats,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "layers",
    iconColor: "black",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.filtered.emptyPrompt.serviceGroups', {
      defaultMessage: 'Service groups'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.filtered.emptyPrompt.message', {
      defaultMessage: 'No groups found for this filter'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "addDataApp",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.data.emptyPrompt.noServiceGroups', {
      defaultMessage: 'No service groups'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.data.emptyPrompt.message', {
      defaultMessage: 'Start grouping and organising your services and your application. Learn more about Service groups or create a group.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_service_group_save.ServiceGroupSaveButton, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 28
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  }))))));
}