"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupSaveButton = ServiceGroupSaveButton;
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _create_button = require("./create_button");
var _edit_button = require("./edit_button");
var _save_modal = require("./save_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_group_save/save_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServiceGroupSaveButton() {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    query: {
      serviceGroup
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/service-groups', '/services', '/service-map');
  const isGroupEditMode = !!serviceGroup;
  const {
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (isGroupEditMode) {
      return callApmApi('GET /internal/apm/service-group', {
        params: {
          query: {
            serviceGroup
          }
        }
      });
    }
  }, [serviceGroup, isGroupEditMode]);
  const savedServiceGroup = data === null || data === void 0 ? void 0 : data.serviceGroup;
  function onClick() {
    setIsModalVisible(state => !state);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isGroupEditMode ? /*#__PURE__*/_react.default.createElement(_edit_button.EditButton, {
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 26
    }
  }) : /*#__PURE__*/_react.default.createElement(_create_button.CreateButton, {
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 61
    }
  }), isModalVisible && /*#__PURE__*/_react.default.createElement(_save_modal.SaveGroupModal, {
    savedServiceGroup: savedServiceGroup,
    onClose: () => {
      setIsModalVisible(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }));
}