"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSessionMapLayerList = getSessionMapLayerList;
var _common = require("@kbn/maps-plugin/common");
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _apm = require("../../../../../../../common/es_fields/apm");
var _get_map_layer_style = require("./get_map_layer_style");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PER_COUNTRY_LAYER_ID = 'per_country';
const PER_REGION_LAYER_ID = 'per_region';
const COUNTRY_NAME = 'name';
const SESSION_PER_COUNTRY = `__kbnjoin__cardinality_of_session.id__${PER_COUNTRY_LAYER_ID}`;
const SESSION_PER_REGION = `__kbnjoin__cardinality_of_session.id__${PER_REGION_LAYER_ID}`;
const label = _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.session.metric.label', {
  defaultMessage: 'Sessions'
});
function getSessionMapLayerList(maps, dataViewId, styleColors) {
  const sessionsByCountryLayer = {
    joins: [{
      leftField: 'iso2',
      right: {
        type: _common.SOURCE_TYPES.ES_TERM_SOURCE,
        id: PER_COUNTRY_LAYER_ID,
        term: _apm.CLIENT_GEO_COUNTRY_ISO_CODE,
        metrics: [{
          type: _common.AGG_TYPE.UNIQUE_COUNT,
          field: _apm.SESSION_ID,
          label
        }],
        indexPatternId: dataViewId,
        applyGlobalQuery: true,
        applyGlobalTime: true,
        applyForceRefresh: true
      }
    }],
    sourceDescriptor: {
      type: _common.SOURCE_TYPES.EMS_FILE,
      id: 'world_countries',
      tooltipProperties: [COUNTRY_NAME]
    },
    style: (0, _get_map_layer_style.getLayerStyle)(SESSION_PER_COUNTRY, _get_map_layer_style.PalleteColors.BluetoRed, styleColors),
    id: (0, _uuid.v4)(),
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.sessionCountry.metric.label', {
      defaultMessage: 'Sessions per country'
    }),
    minZoom: 0,
    maxZoom: 2,
    alpha: 0.75,
    visible: true,
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
  const sessionsByRegionLayer = {
    joins: [{
      leftField: 'region_iso_code',
      right: {
        type: _common.SOURCE_TYPES.ES_TERM_SOURCE,
        id: PER_REGION_LAYER_ID,
        term: _apm.CLIENT_GEO_REGION_ISO_CODE,
        metrics: [{
          type: _common.AGG_TYPE.UNIQUE_COUNT,
          field: _apm.SESSION_ID,
          label
        }],
        indexPatternId: dataViewId,
        applyGlobalQuery: true,
        applyGlobalTime: true,
        applyForceRefresh: true
      }
    }],
    sourceDescriptor: {
      type: _common.SOURCE_TYPES.EMS_FILE,
      id: 'administrative_regions_lvl2',
      tooltipProperties: ['region_iso_code']
    },
    style: (0, _get_map_layer_style.getLayerStyle)(SESSION_PER_REGION, _get_map_layer_style.PalleteColors.YellowtoRed, styleColors),
    id: (0, _uuid.v4)(),
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.sessionRegion.metric.label', {
      defaultMessage: 'Sessions per region'
    }),
    minZoom: 1,
    maxZoom: 24,
    alpha: 0.75,
    visible: true,
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
  return [sessionsByRegionLayer, sessionsByCountryLayer];
}