"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileTreemap = MobileTreemap;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _treemap_select = require("./treemap_select");
var _treemap_chart = require("../../../../shared/charts/treemap_chart");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _apm = require("../../../../../../common/es_fields/apm");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/charts/mobile_most_affected/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ES_FIELD_MAPPING = {
  [_treemap_select.TreemapTypes.Devices]: _apm.DEVICE_MODEL_IDENTIFIER,
  [_treemap_select.TreemapTypes.AppVersions]: _apm.SERVICE_VERSION,
  [_treemap_select.TreemapTypes.OsVersions]: _apm.HOST_OS_VERSION
};
function MobileTreemap({
  kuery,
  serviceName,
  start,
  end,
  environment
}) {
  var _data$terms;
  const [selectedTreemap, selectTreemap] = (0, _react.useState)(_treemap_select.TreemapTypes.Devices);
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    const fieldName = ES_FIELD_MAPPING[selectedTreemap];
    if (fieldName) {
      return callApmApi('GET /internal/apm/mobile-services/{serviceName}/terms', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            fieldName,
            size: 500
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, selectedTreemap]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_treemap_select.TreemapSelect, {
    selectedTreemap: selectedTreemap,
    onChange: selectTreemap,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_treemap_chart.TreemapChart, {
    fetchStatus: status,
    data: (_data$terms = data === null || data === void 0 ? void 0 : data.terms) !== null && _data$terms !== void 0 ? _data$terms : [],
    id: "device-treemap",
    height: 320,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
}