"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreemapSelect = TreemapSelect;
exports.TreemapTypes = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/charts/mobile_errors_and_crashes_treemap/treemap_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TreemapTypes = exports.TreemapTypes = /*#__PURE__*/function (TreemapTypes) {
  TreemapTypes["Devices"] = "devices";
  TreemapTypes["Versions"] = "versions";
  return TreemapTypes;
}({});
const options = [{
  value: TreemapTypes.Devices,
  label: _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.dropdown.devices', {
    defaultMessage: 'Devices'
  }),
  description: _i18n.i18n.translate('xpack.apm.errorOverview.treemap.dropdown.devices.subtitle', {
    defaultMessage: 'This treemap view allows for easy and faster visual way the most affected devices'
  })
}, {
  value: TreemapTypes.Versions,
  label: _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.versions.devices', {
    defaultMessage: 'Versions'
  }),
  description: _i18n.i18n.translate('xpack.apm.errorOverview.treemap.dropdown.versions.subtitle', {
    defaultMessage: 'This treemap view allows for easy and faster visual way the most affected versions.'
  })
}].map(({
  value,
  label,
  description
}) => ({
  inputDisplay: label,
  value,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, description)))
}));
function TreemapSelect({
  selectedTreemap,
  onChange
}) {
  var _options$find;
  const currentTreemap = (_options$find = options.find(({
    value
  }) => value === selectedTreemap)) !== null && _options$find !== void 0 ? _options$find : options[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.errorOverview.treemap.title', {
    defaultMessage: 'Most affected {currentTreemap}',
    values: {
      currentTreemap: currentTreemap.value
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.errorOverview.treemap.subtitle', {
    defaultMessage: 'Treemap showing the total and most affected {currentTreemap}',
    values: {
      currentTreemap: currentTreemap.value
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      fontWeight: 'bold'
    },
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.show', {
    defaultMessage: 'Show'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    style: {
      minWidth: '300px'
    },
    options: options,
    valueOfSelected: selectedTreemap,
    onChange: onChange,
    itemLayoutAlign: "top",
    hasDividers: true,
    "aria-label": _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.select.ariaLabel', {
      defaultMessage: 'Treemap'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }))));
}