"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependenciesDetailTable = DependenciesDetailTable;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _get_comparison_options = require("../../shared/time_comparison/get_comparison_options");
var _connections = require("../../../../common/connections");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _dependencies_table = require("../../shared/dependencies_table");
var _service_link = require("../../shared/links/apm/service_link");
var _use_time_range = require("../../../hooks/use_time_range");
var _get_comparison_enabled = require("../../shared/time_comparison/get_comparison_enabled");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/dependency_detail_overview/dependencies_detail_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DependenciesDetailTable() {
  var _data$services$map;
  const {
    query: {
      dependencyName,
      rangeFrom,
      rangeTo,
      kuery,
      environment,
      comparisonEnabled: urlComparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/overview');
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const comparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core,
    urlComparisonEnabled
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/dependencies/upstream_services', {
      params: {
        query: {
          dependencyName,
          start,
          end,
          environment,
          numBuckets: 20,
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
          kuery
        }
      }
    });
  }, [start, end, environment, offset, dependencyName, kuery, comparisonEnabled]);
  (0, _react.useEffect)(() => {
    if (status === _use_fetcher.FETCH_STATUS.SUCCESS) {
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        }
      });
    }
  }, [onPageReady, status, rangeFrom, rangeTo]);
  const dependencies = (_data$services$map = data === null || data === void 0 ? void 0 : data.services.map(dependency => {
    const {
      location
    } = dependency;
    const name = (0, _connections.getNodeName)(location);
    if (location.type !== _connections.NodeType.service) {
      throw new Error('Expected a service node');
    }
    return {
      name,
      currentStats: dependency.currentStats,
      previousStats: dependency.previousStats,
      link: /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
        serviceName: location.serviceName,
        agentName: location.agentName,
        query: {
          comparisonEnabled,
          offset,
          environment,
          kuery,
          rangeFrom,
          rangeTo,
          latencyAggregationType: undefined,
          transactionType: undefined,
          serviceGroup: ''
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      })
    };
  })) !== null && _data$services$map !== void 0 ? _data$services$map : [];
  return /*#__PURE__*/_react.default.createElement(_dependencies_table.DependenciesTable, {
    dependencies: dependencies,
    title: _i18n.i18n.translate('xpack.apm.dependencyDetail.dependenciesTableTitle', {
      defaultMessage: 'Upstream services'
    }),
    nameColumnTitle: _i18n.i18n.translate('xpack.apm.dependencyDetail.dependenciesTableColumn', {
      defaultMessage: 'Service'
    }),
    status: status,
    compact: false,
    initialPageSize: 25,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  });
}