"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyConfigOverrides = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _read_argv = require("./read_argv");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONFIG_PREFIXES = ['--elastic.apm', '--telemetry', '--monitoring_collection'];

/**
 * Manually applies the specific configuration overrides we need to load the APM config.
 * Currently, only these are needed:
 *   - server.uuid
 *   - path.data
 *   - elastic.apm.*
 *   - telemetry.*
 *   - monitoring_collection.*
 */
const applyConfigOverrides = (config, argv) => {
  const serverUuid = (0, _read_argv.getArgValue)(argv, '--server.uuid');
  if (serverUuid) {
    (0, _saferLodashSet.set)(config, 'server.uuid', serverUuid);
  }
  const dataPath = (0, _read_argv.getArgValue)(argv, '--path.data');
  if (dataPath) {
    (0, _saferLodashSet.set)(config, 'path.data', dataPath);
  }
  CONFIG_PREFIXES.forEach(prefix => {
    (0, _read_argv.getAllArgKeysValueWithPrefix)(argv, prefix).forEach(([key, value]) => {
      if (typeof value === 'undefined') {
        value = 'true'; // Add support to boolean flags without values (i.e.: --telemetry.enabled)
      }
      (0, _saferLodashSet.set)(config, key, value);
    });
  });
};
exports.applyConfigOverrides = applyConfigOverrides;