"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalExecutionSummaryWithAuth = getGlobalExecutionSummaryWithAuth;
var _authorization = require("../../authorization");
var _audit_events = require("../common/audit_events");
var _common = require("../common");
var _saved_objects = require("../../saved_objects");
var _get_execution_log_aggregation = require("../../lib/get_execution_log_aggregation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getGlobalExecutionSummaryWithAuth(context, {
  dateStart,
  dateEnd
}) {
  var _context$auditLogger2;
  context.logger.debug(`getGlobalExecutionSummaryWithAuth(): getting global execution summary`);
  let authorizationTuple;
  try {
    authorizationTuple = await context.authorization.getFindAuthorizationFilter({
      authorizationEntity: _authorization.AlertingAuthorizationEntity.Alert,
      filterOpts: {
        type: _authorization.AlertingAuthorizationFilterType.KQL,
        fieldNames: {
          ruleTypeId: 'kibana.alert.rule.rule_type_id',
          consumer: 'kibana.alert.rule.consumer'
        }
      }
    });
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.GET_GLOBAL_EXECUTION_SUMMARY,
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.GET_GLOBAL_EXECUTION_SUMMARY
  }));
  const dateNow = new Date();
  const parsedDateStart = (0, _common.parseDate)(dateStart, 'dateStart', dateNow);
  const parsedDateEnd = (0, _common.parseDate)(dateEnd, 'dateEnd', dateNow);
  const eventLogClient = await context.getEventLogClient();
  try {
    const aggResult = await eventLogClient.aggregateEventsWithAuthFilter(_saved_objects.RULE_SAVED_OBJECT_TYPE, authorizationTuple.filter, {
      start: parsedDateStart.toISOString(),
      end: parsedDateEnd.toISOString(),
      aggs: (0, _get_execution_log_aggregation.getExecutionSummaryAggregation)()
    });
    return (0, _get_execution_log_aggregation.formatExecutionSummaryResult)(aggResult);
  } catch (err) {
    context.logger.debug(`rulesClient.getGlobalExecutionSummaryWithAuth(): error searching global execution summary: ${err.message}`);
    throw err;
  }
}