"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInternalRuleTemplateRoute = void 0;
var _response = require("../../../../../common/routes/rule_template/response");
var _get = require("../../../../../common/routes/rule_template/apis/get");
var _types = require("../../../../types");
var _constants = require("../../../constants");
var _lib = require("../../../lib");
var _transform_to_get_response = require("./transforms/transform_to_get_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInternalRuleTemplateRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rule_template/{id}`,
    options: {
      access: 'internal'
    },
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    validate: {
      request: {
        params: _get.getRuleTemplateRequestParamsSchemaV1
      },
      response: {
        200: {
          body: () => _response.ruleTemplateResponseSchemaV1,
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given ID does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const params = req.params;
    const ruleTemplate = await rulesClient.getTemplate({
      id: params.id
    });
    const response = {
      body: (0, _transform_to_get_response.transformGetResponse)(ruleTemplate)
    };
    return res.ok(response);
  })));
};
exports.getInternalRuleTemplateRoute = getInternalRuleTemplateRoute;