"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalExecutionSummaryRoute = void 0;
var _global_execution_summary = require("../../common/routes/rule/apis/global_execution_summary");
var _types = require("../types");
var _lib = require("./lib");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteReq = ({
  date_start: dateStart,
  date_end: dateEnd
}) => ({
  dateStart,
  dateEnd
});
const getGlobalExecutionSummaryRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/_global_execution_summary`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      query: _global_execution_summary.getGlobalExecutionSummarySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const response = {
      body: await rulesClient.getGlobalExecutionSummaryWithAuth(rewriteReq(req.query))
    };
    return res.ok(response);
  })));
};
exports.getGlobalExecutionSummaryRoute = getGlobalExecutionSummaryRoute;