"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformResponse = ({
  page,
  perPage,
  total,
  data: gapsData
}) => ({
  page,
  per_page: perPage,
  total,
  data: gapsData.map(gap => {
    var _gap$internalFields;
    if (!(gap !== null && gap !== void 0 && (_gap$internalFields = gap.internalFields) !== null && _gap$internalFields !== void 0 && _gap$internalFields._id) || !gap.timestamp) {
      return undefined;
    }
    return {
      _id: gap.internalFields._id,
      ...gap.toObject(),
      '@timestamp': gap.timestamp
    };
  }).filter(item => item !== undefined)
});
exports.transformResponse = transformResponse;