"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _alert_navigation_registry = require("./alert_navigation_registry");
var _rule_api = require("./services/rule_api");
var _common = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AlertingPublicPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "alertNavigationRegistry", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "maxAlertsPerRun", void 0);
    this.initContext = initContext;
    this.config = this.initContext.config.get();
    this.maxAlertsPerRun = (0, _common.getMaxAlertLimit)(this.config.rules.run.alerts.max);
  }
  setup(core, plugins) {
    var _this$config$maintena;
    this.alertNavigationRegistry = new _alert_navigation_registry.AlertNavigationRegistry();
    const kibanaVersion = this.initContext.env.packageInfo.version;
    const registerNavigation = async (applicationId, ruleTypeId, handler) => {
      this.alertNavigationRegistry.register(applicationId, ruleTypeId, handler);
    };
    const registerDefaultNavigation = async (applicationId, handler) => this.alertNavigationRegistry.registerDefault(applicationId, handler);
    if ((_this$config$maintena = this.config.maintenanceWindow) !== null && _this$config$maintena !== void 0 && _this$config$maintena.enabled) {
      plugins.management.sections.section.insightsAndAlerting.registerApp({
        id: _common.MAINTENANCE_WINDOWS_APP_ID,
        title: _i18n.i18n.translate('xpack.alerting.management.section.title', {
          defaultMessage: 'Maintenance Windows'
        }),
        async mount(params) {
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/maintenance_windows')));
          const [coreStart, pluginsStart] = await core.getStartServices();
          return renderApp({
            core: coreStart,
            plugins: pluginsStart,
            mountParams: params,
            kibanaVersion
          });
        }
      });
    }
    return {
      registerNavigation,
      registerDefaultNavigation
    };
  }
  start(core) {
    return {
      getNavigation: async ruleId => {
        const rule = await (0, _rule_api.loadRule)({
          http: core.http,
          ruleId
        });
        const ruleType = await (0, _rule_api.loadRuleType)({
          http: core.http,
          id: rule.alertTypeId
        });
        if (!ruleType) {
          // eslint-disable-next-line no-console
          console.log(`Unable to get navigation for rule type "${rule.alertTypeId}" because it is not registered on the server side.`);
          return;
        }
        if (this.alertNavigationRegistry.has(rule.consumer, ruleType)) {
          const navigationHandler = this.alertNavigationRegistry.get(rule.consumer, ruleType);
          const navUrl = navigationHandler(rule);
          if (navUrl) return navUrl;
        }
        if (rule.viewInAppRelativeUrl) {
          return rule.viewInAppRelativeUrl;
        }
      },
      getMaxAlertsPerRun: () => {
        return this.maxAlertsPerRun;
      }
    };
  }
}
exports.AlertingPublicPlugin = AlertingPublicPlugin;