"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamPushErrorFactory = void 0;
var _stream_reducer = require("@kbn/aiops-log-rate-analysis/api/stream_reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper function that will push an error message to the stream.
 * This is implemented as a factory that receives the necessary dependencies
 * which then returns the actual helper function.
 */
const streamPushErrorFactory = (push, logDebugMessage) => {
  return function pushError(m) {
    logDebugMessage('Push error.');
    push((0, _stream_reducer.addError)(m));
  };
};
exports.streamPushErrorFactory = streamPushErrorFactory;