"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndexInfo = void 0;
var _fetch_field_candidates = require("./fetch_field_candidates");
var _get_total_doc_count_request = require("./get_total_doc_count_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Consolidate with duplicate `fetchPValues` in
// `x-pack/solutions/observability/plugins/apm/server/routes/correlations/queries/fetch_duration_field_candidates.ts`

const fetchIndexInfo = async ({
  esClient,
  abortSignal,
  arguments: args
}) => {
  var _fieldCandidates$sele, _fieldCandidates$sele2;
  const {
    skipFieldCandidates = false,
    ...fetchFieldCandidatesArguments
  } = args;
  const {
    textFieldCandidatesOverrides = [],
    ...params
  } = fetchFieldCandidatesArguments;

  // There's a bit of logic involved here because we want to fetch the data
  // in parallel but the call to `fetchFieldCandidates` is optional.

  // #1 First we define the promises that would fetch the data.
  const baselineTotalDocCountPromise = esClient.search((0, _get_total_doc_count_request.getTotalDocCountRequest)({
    ...params,
    start: params.baselineMin,
    end: params.baselineMax
  }), {
    signal: abortSignal,
    maxRetries: 0
  });
  const deviationTotalDocCountPromise = esClient.search((0, _get_total_doc_count_request.getTotalDocCountRequest)({
    ...params,
    start: params.deviationMin,
    end: params.deviationMax
  }), {
    signal: abortSignal,
    maxRetries: 0
  });
  const fetchFieldCandidatesPromise = (0, _fetch_field_candidates.fetchFieldCandidates)({
    esClient,
    abortSignal,
    arguments: fetchFieldCandidatesArguments
  });

  // #2 Then we build an array of these promises. To be able to handle the
  // responses properly we build a tuple based on the types of the promises.
  const promises = [baselineTotalDocCountPromise, deviationTotalDocCountPromise, !skipFieldCandidates ? fetchFieldCandidatesPromise : undefined];

  // #3 Finally, we await the promises and return the results.
  const [respBaselineTotalDocCount, respDeviationTotalDocCount, fieldCandidates] = await Promise.all(promises);
  const baselineTotalDocCount = respBaselineTotalDocCount.hits.total.value;
  const deviationTotalDocCount = respDeviationTotalDocCount.hits.total.value;
  return {
    keywordFieldCandidates: (_fieldCandidates$sele = fieldCandidates === null || fieldCandidates === void 0 ? void 0 : fieldCandidates.selectedKeywordFieldCandidates.sort()) !== null && _fieldCandidates$sele !== void 0 ? _fieldCandidates$sele : [],
    textFieldCandidates: (_fieldCandidates$sele2 = fieldCandidates === null || fieldCandidates === void 0 ? void 0 : fieldCandidates.selectedTextFieldCandidates.sort()) !== null && _fieldCandidates$sele2 !== void 0 ? _fieldCandidates$sele2 : [],
    baselineTotalDocCount,
    deviationTotalDocCount,
    zeroDocsFallback: baselineTotalDocCount === 0 || deviationTotalDocCount === 0
  };
};
exports.fetchIndexInfo = fetchIndexInfo;