"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorRateLimiter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _parse_date = require("./parse_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConnectorRateLimiter {
  constructor({
    config
  }) {
    (0, _defineProperty2.default)(this, "logsByConnectors", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.logsByConnectors = new Map();
    this.config = config;
  }
  log(connectorTypeId) {
    if (!this.config) {
      return;
    }
    const trimmedConnectorTypeId = this.trimLeadingDot(connectorTypeId);
    if (this.config[trimmedConnectorTypeId]) {
      const now = Date.now();
      if (!this.logsByConnectors.has(trimmedConnectorTypeId)) {
        this.logsByConnectors.set(trimmedConnectorTypeId, []);
      }
      this.logsByConnectors.get(trimmedConnectorTypeId).push(now);
    }
  }
  isRateLimited(connectorTypeId) {
    if (this.config) {
      const trimmedConnectorTypeId = this.trimLeadingDot(connectorTypeId);
      this.cleanupOldLogs(trimmedConnectorTypeId);
      if (this.config[trimmedConnectorTypeId]) {
        const count = this.getLogs(trimmedConnectorTypeId).length;
        return count > this.config[trimmedConnectorTypeId].limit;
      }
    }
    return false;
  }
  getLogs(connectorTypeId) {
    return this.logsByConnectors.get(this.trimLeadingDot(connectorTypeId)) || [];
  }
  cleanupOldLogs(connectorTypeId) {
    var _this$config;
    const connectorConfig = (_this$config = this.config) === null || _this$config === void 0 ? void 0 : _this$config[connectorTypeId];
    if (connectorConfig) {
      var _this$logsByConnector;
      const now = Date.now();
      const cutoff = now - (0, _parse_date.parseDuration)(connectorConfig.lookbackWindow);
      const filtered = ((_this$logsByConnector = this.logsByConnectors.get(connectorTypeId)) === null || _this$logsByConnector === void 0 ? void 0 : _this$logsByConnector.filter(ts => ts >= cutoff)) || [];
      if (filtered.length > 0) {
        this.logsByConnectors.set(connectorTypeId, filtered);
      } else {
        this.logsByConnectors.delete(connectorTypeId);
      }
    }
  }
  trimLeadingDot(connectorTypeId) {
    if (connectorTypeId.charAt(0) === '.') {
      return connectorTypeId.replace(/^\./, '');
    }
    return connectorTypeId;
  }
}
exports.ConnectorRateLimiter = ConnectorRateLimiter;