"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsAuthorization = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _saved_objects = require("../constants/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const operationAlias = {
  execute: authorization => [authorization.actions.savedObject.get(_saved_objects.ACTION_SAVED_OBJECT_TYPE, 'get'), authorization.actions.savedObject.get(_saved_objects.ACTION_TASK_PARAMS_SAVED_OBJECT_TYPE, 'create')],
  list: authorization => [authorization.actions.savedObject.get(_saved_objects.ACTION_SAVED_OBJECT_TYPE, 'find')]
};
class ActionsAuthorization {
  constructor({
    request,
    authorization
  }) {
    (0, _defineProperty2.default)(this, "request", void 0);
    (0, _defineProperty2.default)(this, "authorization", void 0);
    this.request = request;
    this.authorization = authorization;
  }
  async ensureAuthorized({
    operation,
    actionTypeId,
    additionalPrivileges = []
  }) {
    var _authorization$mode;
    const {
      authorization
    } = this;
    if (authorization !== null && authorization !== void 0 && (_authorization$mode = authorization.mode) !== null && _authorization$mode !== void 0 && _authorization$mode.useRbacForRequest(this.request)) {
      const checkPrivileges = authorization.checkPrivilegesDynamicallyWithRequest(this.request);
      const privileges = operationAlias[operation] ? operationAlias[operation](authorization) : [authorization.actions.savedObject.get(_saved_objects.ACTION_SAVED_OBJECT_TYPE, operation)];
      const {
        hasAllRequested
      } = await checkPrivileges({
        kibana: [...privileges, ...additionalPrivileges]
      });
      if (!hasAllRequested) {
        throw _boom.default.forbidden(`Unauthorized to ${operation} ${actionTypeId ? `a "${actionTypeId}" action` : `actions`}`);
      }
    }
  }
}
exports.ActionsAuthorization = ActionsAuthorization;