"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setInstanceProperties = setInstanceProperties;
const common_1 = require("@inversifyjs/common");
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const ClassElementMetadataKind_1 = require("../../metadata/models/ClassElementMetadataKind");
function setInstanceProperties(resolveServiceNode) {
    return (params, instance, node) => {
        const propertyAssignmentPromises = [];
        for (const [propertyKey, propertyNode] of node.propertyParams) {
            const metadata = node.classMetadata.properties.get(propertyKey);
            if (metadata === undefined) {
                throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.resolution, `Expecting metadata at property "${propertyKey.toString()}", none found`);
            }
            if (metadata.kind !== ClassElementMetadataKind_1.ClassElementMetadataKind.unmanaged &&
                propertyNode.bindings !== undefined) {
                instance[propertyKey] = resolveServiceNode(params, propertyNode);
                if ((0, common_1.isPromise)(instance[propertyKey])) {
                    propertyAssignmentPromises.push((async () => {
                        instance[propertyKey] = await instance[propertyKey];
                    })());
                }
            }
        }
        if (propertyAssignmentPromises.length > 0) {
            return Promise.all(propertyAssignmentPromises).then(() => undefined);
        }
    };
}
//# sourceMappingURL=setInstanceProperties.js.map