"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryBuildGetPlanOptionsFromManagedClassElementMetadata = tryBuildGetPlanOptionsFromManagedClassElementMetadata;
const common_1 = require("@inversifyjs/common");
const ClassElementMetadataKind_1 = require("../../metadata/models/ClassElementMetadataKind");
function tryBuildGetPlanOptionsFromManagedClassElementMetadata(elementMetadata) {
    let tag;
    if (elementMetadata.tags.size === 0) {
        tag = undefined;
    }
    else if (elementMetadata.tags.size === 1) {
        const [key, value] = elementMetadata.tags
            .entries()
            .next().value;
        tag = { key, value };
    }
    else {
        return undefined;
    }
    const serviceIdentifier = common_1.LazyServiceIdentifier.is(elementMetadata.value)
        ? elementMetadata.value.unwrap()
        : elementMetadata.value;
    if (elementMetadata.kind === ClassElementMetadataKind_1.ClassElementMetadataKind.multipleInjection) {
        return {
            chained: elementMetadata.chained,
            isMultiple: true,
            name: elementMetadata.name,
            optional: elementMetadata.optional,
            serviceIdentifier,
            tag,
        };
    }
    else {
        return {
            isMultiple: false,
            name: elementMetadata.name,
            optional: elementMetadata.optional,
            serviceIdentifier,
            tag,
        };
    }
}
//# sourceMappingURL=tryBuildGetPlanOptionsFromManagedClassElementMetadata.js.map