"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InversifyContainerError = void 0;
const isAppErrorSymbol = Symbol.for('@inversifyjs/container/InversifyContainerError');
class InversifyContainerError extends Error {
    [isAppErrorSymbol];
    kind;
    constructor(kind, message, options) {
        super(message, options);
        this[isAppErrorSymbol] = true;
        this.kind = kind;
    }
    static is(value) {
        return (typeof value === 'object' &&
            value !== null &&
            value[isAppErrorSymbol] === true);
    }
    static isErrorOfKind(value, kind) {
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
        return InversifyContainerError.is(value) && value.kind === kind;
    }
}
exports.InversifyContainerError = InversifyContainerError;
//# sourceMappingURL=InversifyContainerError.js.map