"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cssSupportsSelector = exports.cssSupportsHasWithNextSibling = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var cssSupportsSelector = exports.cssSupportsSelector = function cssSupportsSelector(selector, value) {
  return "\n       @supports selector(".concat(selector, ") {").concat(value, "}\n    ");
};

/**
 * Util to check if the "previous sibling" selector :has(+) is supported
 */
var cssSupportsHasWithNextSibling = exports.cssSupportsHasWithNextSibling = function cssSupportsHasWithNextSibling(value) {
  return cssSupportsSelector(':has(+ *)', value);
};