"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelectableSearch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _form = require("../../form");
var _matching_options = require("../matching_options");
var _react2 = require("@emotion/react");
var _excluded = ["onChange", "options", "value", "placeholder", "isPreFiltered", "listId", "className", "optionMatcher"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiSelectableSearch = exports.EuiSelectableSearch = function EuiSelectableSearch(_ref) {
  var onChangeCallback = _ref.onChange,
    options = _ref.options,
    value = _ref.value,
    placeholder = _ref.placeholder,
    isPreFiltered = _ref.isPreFiltered,
    listId = _ref.listId,
    className = _ref.className,
    optionMatcher = _ref.optionMatcher,
    rest = _objectWithoutProperties(_ref, _excluded);
  var onChange = (0, _react.useCallback)(function (e) {
    var searchValue = e.target.value;
    var matchingOptions = (0, _matching_options.getMatchingOptions)({
      options: options,
      searchValue: searchValue,
      isPreFiltered: isPreFiltered,
      optionMatcher: optionMatcher
    });
    onChangeCallback(searchValue, matchingOptions);
  }, [options, isPreFiltered, onChangeCallback, optionMatcher]);
  var classes = (0, _classnames.default)('euiSelectableSearch', className);
  var ariaPropsIfListIsPresent = listId ? {
    role: 'combobox',
    'aria-autocomplete': 'list',
    'aria-expanded': true,
    'aria-controls': listId,
    'aria-owns': listId // legacy attribute but shims support for nearly everything atm
  } : undefined;
  return (0, _react2.jsx)(_form.EuiFieldSearch, _extends({
    className: classes,
    placeholder: placeholder,
    value: value,
    onChange: onChange,
    incremental: true,
    fullWidth: true,
    autoComplete: "off",
    "aria-haspopup": "listbox"
  }, ariaPropsIfListIsPresent, rest));
};