"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWindowMediaMatcher = void 0;
var _react = require("react");
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var useWindowMediaMatcher = exports.useWindowMediaMatcher = function useWindowMediaMatcher(mediaQuery) {
  // Check typeof and use optional chaining for SSR or test environments
  var _useState = (0, _react.useState)(function () {
      var _window$matchMedia$ma, _window, _window$matchMedia;
      return typeof window !== 'undefined' && ((_window$matchMedia$ma = (_window = window) === null || _window === void 0 || (_window$matchMedia = _window.matchMedia) === null || _window$matchMedia === void 0 || (_window$matchMedia = _window$matchMedia.call(_window, mediaQuery)) === null || _window$matchMedia === void 0 ? void 0 : _window$matchMedia.matches) !== null && _window$matchMedia$ma !== void 0 ? _window$matchMedia$ma : false);
    }),
    _useState2 = _slicedToArray(_useState, 2),
    mediaMatches = _useState2[0],
    setMediaMatches = _useState2[1];

  // Listen for system changes
  (0, _react.useEffect)(function () {
    var _window$matchMedia2, _window2, _window$matchMedia2$c, _window$matchMedia2$c2;
    var eventListener = function eventListener(event) {
      setMediaMatches(event.matches);
    };

    // Optional chaining here is for test environments - SSR should not run useEffect
    (_window$matchMedia2 = (_window2 = window).matchMedia) === null || _window$matchMedia2 === void 0 || (_window$matchMedia2$c = (_window$matchMedia2$c2 = _window$matchMedia2.call(_window2, mediaQuery)).addEventListener) === null || _window$matchMedia2$c === void 0 || _window$matchMedia2$c.call(_window$matchMedia2$c2, 'change', eventListener);

    // Clean up the listener on unmount
    return function () {
      var _window$matchMedia3, _window3, _window$matchMedia3$c, _window$matchMedia3$c2;
      (_window$matchMedia3 = (_window3 = window).matchMedia) === null || _window$matchMedia3 === void 0 || (_window$matchMedia3$c = (_window$matchMedia3$c2 = _window$matchMedia3.call(_window3, mediaQuery)).removeEventListener) === null || _window$matchMedia3$c === void 0 || _window$matchMedia3$c.call(_window$matchMedia3$c2, 'change', eventListener);
    };
  }, [mediaQuery]);
  return mediaMatches;
};