"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkdownEditorFooterStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _markdown_editor = require("./markdown_editor.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiMarkdownEditorFooterStyles = exports.euiMarkdownEditorFooterStyles = function euiMarkdownEditorFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiMarkdownEditorVar = (0, _markdown_editor.euiMarkdownEditorVariables)(euiThemeContext),
    borderRadius = _euiMarkdownEditorVar.borderRadius,
    barsBackgroundColor = _euiMarkdownEditorVar.barsBackgroundColor;
  return {
    euiMarkdownEditorFooter: /*#__PURE__*/(0, _react.css)("display:inline-flex;align-items:center;padding:", euiTheme.size.xs, ";border:", euiTheme.border.thin, ";background-color:", barsBackgroundColor, ";;label:euiMarkdownEditorFooter;"),
    euiMarkdownEditorFooter__actions: /*#__PURE__*/(0, _react.css)("flex:1;display:inline-flex;align-items:center;gap:", euiTheme.size.xs, ";;label:euiMarkdownEditorFooter__actions;"),
    // Override default button border radius to match the overall markdown editor
    euiMarkdownEditorFooter__uploadError: /*#__PURE__*/(0, _react.css)("border-radius:", borderRadius, ";;label:euiMarkdownEditorFooter__uploadError;"),
    euiMarkdownEditorFooter__popover: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '300px'), ";;label:euiMarkdownEditorFooter__popover;")
  };
};