"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkdownEditorVariables = exports.euiMarkdownEditorStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiMarkdownEditorVariables = exports.euiMarkdownEditorVariables = function euiMarkdownEditorVariables(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    minHeight: '150px',
    borderRadius: euiTheme.border.radius.medium,
    barsBackgroundColor: euiTheme.colors.lightestShade
  };
};
var euiMarkdownEditorStyles = exports.euiMarkdownEditorStyles = function euiMarkdownEditorStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiMarkdownEditorVar = euiMarkdownEditorVariables(euiThemeContext),
    minHeight = _euiMarkdownEditorVar.minHeight,
    borderRadius = _euiMarkdownEditorVar.borderRadius;
  return {
    euiMarkdownEditor: /*#__PURE__*/(0, _react.css)("display:flex;flex-direction:column;.euiMarkdownEditorToolbar{", (0, _global_styling.logicalBorderRadiusCSS)("".concat(borderRadius, " ").concat(borderRadius, " 0 0"), true), ";}.euiMarkdownEditorPreview,.euiMarkdownEditorFooter{", (0, _global_styling.logicalBorderRadiusCSS)("0 0 ".concat(borderRadius, " ").concat(borderRadius), true), ";};label:euiMarkdownEditor;"),
    fullHeight: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), " .euiMarkdownEditorTextArea{resize:none;}.euiMarkdownEditorDropZone{", (0, _global_styling.logicalCSS)('height', '100%'), ";};label:fullHeight;"),
    euiMarkdownEditorPreview: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-height', minHeight), " ", (0, _global_styling.logicalCSSWithFallback)('overflow-y', 'auto'), " ", (0, _global_styling.euiScrollBarStyles)(euiThemeContext), " padding:", euiTheme.size.m, ";border:", euiTheme.border.thin, ";background-color:", euiTheme.colors.emptyShade, ";;label:euiMarkdownEditorPreview;")
  };
};