"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiHeaderVariables = exports.euiHeaderStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _form = require("../form/form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiHeaderVariables = exports.euiHeaderVariables = function euiHeaderVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    height: euiTheme.size.xxxl,
    childHeight: euiTheme.size.xxl,
    padding: euiTheme.size.s
  };
};
var euiHeaderStyles = exports.euiHeaderStyles = function euiHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiHeaderVariables = euiHeaderVariables(euiThemeContext),
    height = _euiHeaderVariables.height,
    padding = _euiHeaderVariables.padding;
  return {
    euiHeader: /*#__PURE__*/(0, _react.css)("display:flex;justify-content:space-between;", (0, _global_styling.logicalCSS)('height', height), " ", (0, _global_styling.logicalCSS)('padding-horizontal', padding), " ", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), " ", (0, _euiThemeCommon.euiShadowXSmall)(euiThemeContext), ";;label:euiHeader;"),
    // Position
    static: /*#__PURE__*/(0, _react.css)("z-index:", Number(euiTheme.levels.header) - 1, ";position:relative;;label:static;"),
    fixed: /*#__PURE__*/(0, _react.css)("z-index:", Number(euiTheme.levels.header) + 1, ";position:fixed;", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('horizontal', 0), ";;label:fixed;"),
    // Theme
    default: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.components.headerBackground, ";;label:default;"),
    dark: /*#__PURE__*/(0, _react.css)(euiHeaderDarkStyles(euiThemeContext), ";label:dark;")
  };
};

/**
 * The `dark` header is (currently) a bit of a special case. We don't
 * actually want to use <EuiThemeProvider colorMode="dark"> inside it
 * because that will affect popovers and `SelectableSitewideTemplate`
 * as well, which we do not necessarily want to do (?)
 *
 * It's also possible that the dark header will go away or become unused
 * by Kibana in the near future, at which point we can remove this
 */

var euiHeaderDarkStyles = function euiHeaderDarkStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    controlPlaceholderText = _euiFormVariables.controlPlaceholderText;
  var backgroundColor = euiTheme.components.headerDarkBackground;

  // Specific color overrides for EuiSelectableTemplateSitewide
  var selectableSitewide = {
    color: euiTheme.colors.ghost,
    borderColor: euiTheme.components.headerDarkSearchBorderColor,
    placeholderColor: (0, _services.makeHighContrastColor)(controlPlaceholderText, 8)(backgroundColor)
  };
  var formLayoutStyles = "\n    .euiSelectableTemplateSitewide .euiFormControlLayout {\n      background-color: transparent;\n\n      input {\n        box-shadow: inset 0 0 0 ".concat(euiTheme.border.width.thin, " ").concat(selectableSitewide.borderColor, ";\n      }\n\n      &--group {\n        border-color: ").concat(
  // the header is in a faux dark mode, we can't rely on color
  // switch tokens as they'd be in the wrong color mode
  highContrastMode ? euiTheme.colors.plainLight : euiTheme.components.headerDarkSearchBorderColor, ";\n\n        input {\n          box-shadow: none;\n        }\n      }\n\n      &__append {\n        border-color: ").concat(highContrastMode ? euiTheme.colors.plainLight : '', "\n      }\n\n      &:not(:focus-within) {\n        /* Increase contrast of filled text to be more than placeholder text */\n        color: ").concat(selectableSitewide.color, ";\n\n        input {\n          /* Increase contrast of placeholder text */\n          &::placeholder {\n            color: ").concat(selectableSitewide.placeholderColor, ";\n          }\n\n          /* Inherit color from form control layout */\n          color: inherit;\n          background-color: transparent;\n        }\n\n        .euiFormControlLayout__append,\n        .euiFormControlLayout__prepend {\n          background-color: transparent;\n        }\n\n        .euiFormLabel {\n          color: inherit;\n        }\n      }\n  }\n  ");
  return "\n    background-color: ".concat(backgroundColor, ";\n\n    .euiHeaderLogo__text,\n    .euiHeaderLink,\n    .euiHeaderSectionItemButton {\n      color: ").concat(euiTheme.colors.ghost, ";\n    }\n\n    .euiHeaderLink-isActive {\n      color: ").concat((0, _services.makeHighContrastColor)(euiTheme.colors.primary)(backgroundColor), ";\n    }\n\n    .euiHeaderLogo,\n    .euiHeaderLink,\n    .euiHeaderSectionItemButton {\n      &:focus {\n        background-color: ").concat(euiTheme.components.headerDarkSectionItemBackgroundFocus, ";\n      }\n    }\n\n    .euiHeaderSectionItemButton__notification--badge {\n      box-shadow: 0 0 0 ").concat(euiTheme.border.width.thin, " ").concat(backgroundColor, ";\n    }\n\n    .euiHeaderSectionItemButton__notification--dot {\n      stroke: ").concat(backgroundColor, ";\n    }\n\n    ").concat(!isRefreshVariant && formLayoutStyles, " \n  ");
};