"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormControlLayoutClearButtonStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiFormControlLayoutClearButtonStyles = exports.EuiFormControlLayoutClearButtonStyles = function EuiFormControlLayoutClearButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var backgroundColor = highContrastMode ? euiTheme.colors.darkShade : euiTheme.components.forms.clearButtonBackground;
  return {
    euiFormControlLayoutClearButton: /*#__PURE__*/(0, _react.css)("pointer-events:all;display:flex;justify-content:center;align-items:center;border-radius:50%;border-style:solid;border-color:", backgroundColor, ";&:disabled{cursor:not-allowed;background-color:", isRefreshVariant ? euiTheme.colors.backgroundBaseDisabled : euiTheme.colors.disabled, ";};label:euiFormControlLayoutClearButton;"),
    size: {
      s: "\n        ".concat((0, _global_styling.logicalSizeCSS)(euiTheme.size.m), "\n        border-width: ").concat((0, _global_styling.mathWithUnits)(euiTheme.size.m, function (x) {
        return x / 2;
      }), ";\n      "),
      m: "\n        ".concat((0, _global_styling.logicalSizeCSS)(euiTheme.size.base), "\n        border-width: ").concat((0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
        return x / 2;
      }), ";\n      ")
    },
    icon: {
      euiFormControlLayoutClearButton__icon: /*#__PURE__*/(0, _react.css)("transform:scale(0.5);fill:", euiTheme.colors.emptyShade, ";stroke:", euiTheme.colors.emptyShade, ";;label:euiFormControlLayoutClearButton__icon;"),
      size: {
        s: /*#__PURE__*/(0, _react.css)("stroke-width:", euiTheme.size.xs, ";;label:s;"),
        m: /*#__PURE__*/(0, _react.css)("stroke-width:", euiTheme.size.xxs, ";;label:m;")
      }
    }
  };
};