"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAutoRefreshButton = exports.EuiAutoRefresh = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _form = require("../../form");
var _button_empty = require("../../button/button_empty/button_empty");
var _popover = require("../../popover");
var _i18n = require("../../i18n");
var _pretty_interval = require("../super_date_picker/pretty_interval");
var _refresh_interval = require("./refresh_interval");
var _react2 = require("@emotion/react");
var _excluded = ["className", "onRefreshChange", "intervalUnits", "isDisabled", "isPaused", "refreshInterval", "minInterval", "readOnly"],
  _excluded2 = ["className", "onRefreshChange", "intervalUnits", "isDisabled", "isPaused", "refreshInterval", "minInterval", "shortHand", "size", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiAutoRefresh = exports.EuiAutoRefresh = function EuiAutoRefresh(_ref) {
  var className = _ref.className,
    onRefreshChange = _ref.onRefreshChange,
    intervalUnits = _ref.intervalUnits,
    isDisabled = _ref.isDisabled,
    _ref$isPaused = _ref.isPaused,
    isPaused = _ref$isPaused === void 0 ? true : _ref$isPaused,
    _ref$refreshInterval = _ref.refreshInterval,
    refreshInterval = _ref$refreshInterval === void 0 ? 1000 : _ref$refreshInterval,
    _ref$minInterval = _ref.minInterval,
    minInterval = _ref$minInterval === void 0 ? 0 : _ref$minInterval,
    _ref$readOnly = _ref.readOnly,
    readOnly = _ref$readOnly === void 0 ? true : _ref$readOnly,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiAutoRefresh', className);
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var autoRefeshLabel = (0, _i18n.useEuiI18n)('euiAutoRefresh.autoRefreshLabel', 'Auto refresh');
  return (0, _react2.jsx)(_popover.EuiInputPopover, {
    className: classes,
    fullWidth: rest.fullWidth,
    input: (0, _react2.jsx)(_form.EuiFieldText, _extends({
      "aria-label": autoRefeshLabel,
      onClick: function onClick() {
        return setIsPopoverOpen(function (isOpen) {
          return !isOpen;
        });
      },
      prepend: (0, _react2.jsx)(_button_empty.EuiButtonEmpty, {
        className: "euiFormControlLayout__prepend",
        onClick: function onClick() {
          return setIsPopoverOpen(function (isOpen) {
            return !isOpen;
          });
        },
        size: "s",
        color: "text",
        iconType: "timeRefresh",
        isDisabled: isDisabled
      }, (0, _react2.jsx)("strong", null, (0, _react2.jsx)("small", null, autoRefeshLabel))),
      readOnly: readOnly,
      disabled: isDisabled,
      value: (0, _pretty_interval.usePrettyInterval)(Boolean(isPaused), refreshInterval, {
        unit: intervalUnits
      })
    }, rest)),
    isOpen: isPopoverOpen,
    closePopover: function closePopover() {
      setIsPopoverOpen(false);
    }
  }, (0, _react2.jsx)(_refresh_interval.EuiRefreshInterval, {
    onRefreshChange: onRefreshChange,
    isPaused: isPaused,
    refreshInterval: refreshInterval,
    minInterval: minInterval,
    intervalUnits: intervalUnits
  }));
};
EuiAutoRefresh.propTypes = {
  /**
     * Is refresh paused or running.
     */
  isPaused: _propTypes.default.bool,
  refreshInterval: _propTypes.default.number,
  minInterval: _propTypes.default.number,
  /**
     * By default, refresh interval units will be rounded up to next largest unit of time
     * (for example, 90 seconds will become 2m).
     *
     * If you do not want this behavior, you can manually control the rendered unit via this prop.
     */
  intervalUnits: _propTypes.default.any,
  /**
     * Passes back the updated state of `isPaused`, `refreshInterval`, and `intervalUnits`.
     */
  onRefreshChange: _propTypes.default.func.isRequired,
  isDisabled: _propTypes.default.bool,
  /**
     * The input is `readOnly` by default because the input value is handled by the popover form.
     */
  readOnly: _propTypes.default.any
};
var EuiAutoRefreshButton = exports.EuiAutoRefreshButton = function EuiAutoRefreshButton(_ref2) {
  var className = _ref2.className,
    onRefreshChange = _ref2.onRefreshChange,
    intervalUnits = _ref2.intervalUnits,
    isDisabled = _ref2.isDisabled,
    _ref2$isPaused = _ref2.isPaused,
    isPaused = _ref2$isPaused === void 0 ? true : _ref2$isPaused,
    _ref2$refreshInterval = _ref2.refreshInterval,
    refreshInterval = _ref2$refreshInterval === void 0 ? 1000 : _ref2$refreshInterval,
    _ref2$minInterval = _ref2.minInterval,
    minInterval = _ref2$minInterval === void 0 ? 0 : _ref2$minInterval,
    _ref2$shortHand = _ref2.shortHand,
    shortHand = _ref2$shortHand === void 0 ? false : _ref2$shortHand,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? 's' : _ref2$size,
    _ref2$color = _ref2.color,
    color = _ref2$color === void 0 ? 'text' : _ref2$color,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isPopoverOpen = _useState4[0],
    setIsPopoverOpen = _useState4[1];
  var classes = (0, _classnames.default)('euiAutoRefreshButton', className);
  var autoRefeshLabelOff = (0, _i18n.useEuiI18n)('euiAutoRefresh.buttonLabelOff', 'Auto refresh is off');
  var autoRefeshLabelOn = (0, _i18n.useEuiI18n)('euiAutoRefresh.buttonLabelOn', 'Auto refresh is on and set to {prettyInterval}', {
    prettyInterval: (0, _pretty_interval.usePrettyInterval)(Boolean(isPaused), refreshInterval, {
      unit: intervalUnits
    })
  });
  return (0, _react2.jsx)(_popover.EuiPopover, {
    button: (0, _react2.jsx)(_button_empty.EuiButtonEmpty, _extends({
      onClick: function onClick() {
        return setIsPopoverOpen(function (isOpen) {
          return !isOpen;
        });
      },
      className: classes,
      size: size,
      color: color,
      iconType: "timeRefresh",
      title: isPaused ? autoRefeshLabelOff : autoRefeshLabelOn,
      isDisabled: isDisabled
    }, rest), (0, _pretty_interval.usePrettyInterval)(Boolean(isPaused), refreshInterval, {
      shortHand: shortHand,
      unit: intervalUnits
    })),
    isOpen: isPopoverOpen,
    closePopover: function closePopover() {
      setIsPopoverOpen(false);
    },
    popoverScreenReaderText: isPaused ? autoRefeshLabelOff : autoRefeshLabelOn
  }, (0, _react2.jsx)(_refresh_interval.EuiRefreshInterval, {
    onRefreshChange: onRefreshChange,
    isPaused: isPaused,
    refreshInterval: refreshInterval,
    minInterval: minInterval,
    intervalUnits: intervalUnits
  }));
};
EuiAutoRefreshButton.propTypes = {
  isPaused: _propTypes.default.bool,
  refreshInterval: _propTypes.default.number,
  minInterval: _propTypes.default.number,
  intervalUnits: _propTypes.default.any,
  onRefreshChange: _propTypes.default.func.isRequired,
  /**
     * `disabled` is also allowed
     */
  isDisabled: _propTypes.default.bool,
  /**
     * Reduces the time unit to a single letter
     */
  shortHand: _propTypes.default.bool,
  /**
     * Any of the named color palette options.
     *
     * Do not use the following colors for standalone buttons directly,
     * they exist to serve other components:
     *  - accent
     *  - warning
     *  - neutral
     *  - risk
     */
  color: _propTypes.default.any,
  size: _propTypes.default.any,
  /**
     * Ensure the text of the button sits flush to the left, right, or both sides of its container
     */
  flush: _propTypes.default.any,
  /**
     * Force disables the button and changes the icon to a loading spinner
     */
  isLoading: _propTypes.default.bool,
  href: _propTypes.default.string,
  target: _propTypes.default.string,
  rel: _propTypes.default.string,
  buttonRef: _propTypes.default.any,
  /**
     * Object of props passed to the `<span>` wrapping the button's content
     */
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
     * Object of props passed to the `<span>` wrapping the content's text/children only (not icon)
     *
     * This span wrapper can be removed by passing `textProps={false}`.
     */
  textProps: _propTypes.default.oneOfType([_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    ref: _propTypes.default.any,
    "data-text": _propTypes.default.string
  }).isRequired, _propTypes.default.oneOf([false])]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};