"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultItemAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _tool_tip = require("../tool_tip");
var _accessibility = require("../../services/accessibility");
var _accessibility2 = require("../accessibility");
var _action_types = require("./action_types");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var DefaultItemAction = exports.DefaultItemAction = function DefaultItemAction(_ref) {
  var action = _ref.action,
    enabled = _ref.enabled,
    item = _ref.item,
    className = _ref.className;
  if (!action.onClick && !action.href) {
    throw new Error("Cannot render item action [".concat(action.name, "]. Missing required 'onClick' callback\n      or 'href' string. If you want to provide a custom action control, make sure to define the 'render' callback"));
  }
  var onClick = (0, _react.useCallback)(function (event) {
    if (!action.onClick) return;
    event.persist(); // TODO: Remove once React 16 support is dropped
    action.onClick(item, event);
  }, [action.onClick, item]);
  var color = action.color ? (0, _action_types.callWithItemIfFunction)(item)(action.color) : 'primary';
  var icon = action.icon ? (0, _action_types.callWithItemIfFunction)(item)(action.icon) : undefined;
  var actionContent = (0, _action_types.callWithItemIfFunction)(item)(action.name);
  var tooltipContent = (0, _action_types.callWithItemIfFunction)(item)(action.description);
  var href = (0, _action_types.callWithItemIfFunction)(item)(action.href);
  var dataTestSubj = (0, _action_types.callWithItemIfFunction)(item)(action['data-test-subj']);
  var ariaLabelId = (0, _accessibility.useGeneratedHtmlId)();
  var ariaLabelledBy;
  var button;
  if (action.type === 'icon') {
    if (!icon) {
      throw new Error("Cannot render item action [".concat(action.name, "]. It is configured to render as an icon but no\n      icon is provided. Make sure to set the 'icon' property of the action"));
    }
    button = (0, _react2.jsx)(_button.EuiButtonIcon, {
      className: className,
      "aria-labelledby": ariaLabelId,
      isDisabled: !enabled,
      color: color,
      iconType: icon,
      onClick: onClick,
      href: href,
      target: action.target,
      "data-test-subj": dataTestSubj
      // If action is disabled, the normal tooltip can't show - attempt to
      // provide some amount of affordance with a browser title tooltip
      ,
      title: !enabled ? tooltipContent : undefined
    });
    // actionContent (action.name) is a ReactNode and must be rendered
    // to an element and referenced by ID for screen readers
    ariaLabelledBy = (0, _react2.jsx)(_accessibility2.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", {
      id: ariaLabelId
    }, actionContent));
  } else {
    button = (0, _react2.jsx)(_button.EuiButtonEmpty, {
      className: className,
      size: "s",
      isDisabled: !enabled,
      color: color,
      iconType: icon,
      onClick: onClick,
      href: href,
      target: action.target,
      "data-test-subj": dataTestSubj,
      flush: "right"
    }, actionContent);
  }
  return enabled ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_tool_tip.EuiToolTip, {
    content: tooltipContent,
    delay: "long"
  }, button), ariaLabelledBy) : (0, _react2.jsx)(_react.default.Fragment, null, button, ariaLabelledBy);
};