"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBetaBadgeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _color_utils = require("../color_utils");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;"
} : {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;"
} : {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "pzpqqg-euiBetaBadge__icon",
  styles: "position:relative;transform:translate(0, -1px);label:euiBetaBadge__icon;"
} : {
  name: "pzpqqg-euiBetaBadge__icon",
  styles: "position:relative;transform:translate(0, -1px);label:euiBetaBadge__icon;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiBetaBadgeStyles = exports.euiBetaBadgeStyles = function euiBetaBadgeStyles(euiThemeContext) {
  var _euiTheme$flags;
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var badgeColors = (0, _color_utils.euiBadgeColors)(euiThemeContext);
  var badgeSizes = {
    m: euiTheme.size.l,
    s: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 1.25;
    })
  };
  var hasVisColorAdjustment = (_euiTheme$flags = euiTheme.flags) === null || _euiTheme$flags === void 0 ? void 0 : _euiTheme$flags.hasVisColorAdjustment;
  return {
    euiBetaBadge: /*#__PURE__*/(0, _react.css)("display:inline-block;border-radius:", euiTheme.size.l, ";border:", euiTheme.border.width.thin, " solid transparent;cursor:default;font-weight:", euiTheme.font.weight.semiBold, ";text-transform:uppercase;letter-spacing:0.05em;text-align:center;", (0, _global_styling.euiTextTruncate)(), " &:focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'outset', {
      color: colorMode === 'DARK' ? euiTheme.colors.ghost : euiTheme.colors.ink
    }), ";};label:euiBetaBadge;"),
    // Colors
    accent: hasVisColorAdjustment ? /*#__PURE__*/(0, _react.css)(badgeColors.accentText, ";label:accent;") : /*#__PURE__*/(0, _react.css)(badgeColors.accent, ";label:accent;"),
    subdued: /*#__PURE__*/(0, _react.css)(badgeColors.subdued, ";label:subdued;"),
    hollow: /*#__PURE__*/(0, _react.css)("color:", badgeColors.hollow.color, ";background-color:", badgeColors.hollow.backgroundColor, ";border-color:", badgeColors.hollow.borderColor, ";;label:hollow;"),
    warning: /*#__PURE__*/(0, _react.css)(badgeColors.warning, ";label:warning;"),
    // Font sizes
    m: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSizeFromScale)('xs', euiTheme), ";line-height:", badgeSizes.m, ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)("font-size:0.7rem;line-height:", badgeSizes.s, ";;label:s;"),
    badgeSizes: {
      default: {
        m: "\n        ".concat((0, _global_styling.logicalCSS)('height', badgeSizes.m), "\n        ").concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base), "\n        "),
        s: "\n        ".concat((0, _global_styling.logicalCSS)('height', badgeSizes.s), "\n        ").concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.m), "\n        ")
      },
      // When it's just an icon or a single letter, make the badge a circle
      circle: {
        m: (0, _global_styling.logicalSizeCSS)(badgeSizes.m),
        s: (0, _global_styling.logicalSizeCSS)(badgeSizes.s)
      }
    },
    euiBetaBadge__icon: _ref3,
    // Alignments
    baseline: _ref2,
    middle: _ref
  };
};