"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getScreenReaderSummarySelector = void 0;
const get_accessibility_config_1 = require("./get_accessibility_config");
const get_internal_chart_state_1 = require("./get_internal_chart_state");
const get_internal_is_intialized_1 = require("./get_internal_is_intialized");
const create_selector_1 = require("../create_selector");
const DEFAULT_SCREEN_READER_SUMMARY = {
    a11ySettings: get_accessibility_config_1.DEFAULT_A11Y_SETTINGS,
    screenReaderData: undefined,
};
exports.getScreenReaderSummarySelector = (0, create_selector_1.createCustomCachedSelector)([
    get_internal_chart_state_1.getInternalChartStateSelector,
    get_internal_is_intialized_1.getInternalIsInitializedSelector,
    get_accessibility_config_1.getA11ySettingsSelector,
    (state) => state,
], (internalChartState, initStatus, a11ySettings, state) => {
    if (internalChartState === null || initStatus !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return DEFAULT_SCREEN_READER_SUMMARY;
    }
    const screenReaderData = internalChartState.getScreenReaderData?.(state);
    return {
        a11ySettings,
        screenReaderData,
    };
});
//# sourceMappingURL=get_screen_reader_summary.js.map