"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLegendTableSize = getLegendTableSize;
const default_theme_attributes_1 = require("../../common/default_theme_attributes");
const legend_1 = require("../../common/legend");
const legend_table_1 = require("../../components/legend/legend_table/legend_table");
const common_1 = require("../../utils/common");
const MONO_LETTER_WIDTH = 8.5;
const MONO_SEPARATOR_WIDTH = 4.5;
const SCROLL_BAR_WIDTH = 16;
const VERTICAL_PADDING = 4;
const TOP_MARGIN = 2;
const GRID_CELL_PADDING = { height: 4, width: 8 };
const GRID_MARGIN = 8;
const HORIZONTAL_VISIBLE_LINES_NUMBER = 4;
const GRID_CELL_BORDER_WIDTH = 1;
const fontArgs = [
    {
        fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
        fontWeight: 400,
        fontVariant: 'normal',
        fontStyle: 'normal',
        textColor: 'black',
    },
    12,
    1.34,
];
const headerFontArgs = [
    {
        ...fontArgs[0],
        fontWeight: 600,
    },
    fontArgs[1],
    fontArgs[2],
];
const calcApprValuesWidth = ({ label }) => label.includes('.')
    ? (label.length - 1) * MONO_LETTER_WIDTH + MONO_SEPARATOR_WIDTH
    : label.length * MONO_LETTER_WIDTH;
function getLegendTableSize(config, theme, parentDimensions, items, textMeasure) {
    const { legend: { verticalWidth, spacingBuffer, margin }, } = theme;
    const { legendSize, legendValues, legendPosition, legendAction } = config;
    const { width: titleWidth, height } = textMeasure(config.legendTitle || '', ...headerFontArgs);
    const valuesTitlesWidth = legendValues.map((v) => textMeasure(legend_1.legendValueTitlesMap[v], ...headerFontArgs).width);
    const widestLabelWidth = items.reduce((acc, { label }) => Math.max(acc, textMeasure(label, ...fontArgs).width), Math.max(titleWidth, legend_table_1.MIN_LABEL_WIDTH));
    const widestValuesWidths = items.reduce((acc, { values }) => {
        const valuesWidths = values.map(calcApprValuesWidth);
        return acc.map((w, i) => Math.ceil(Math.max(w, valuesWidths[i] || 0)));
    }, valuesTitlesWidth);
    const seriesWidth = Math.ceil(widestLabelWidth + GRID_CELL_PADDING.width * 2);
    const legendItemWidth = seriesWidth + widestValuesWidths.reduce((acc, w) => acc + w + GRID_CELL_PADDING.width * 2, 0) + 1;
    const actionWidth = (0, common_1.isDefined)(legendAction) ? legend_table_1.GRID_ACTION_WIDTH : 0;
    if (legendPosition.direction === common_1.LayoutDirection.Vertical) {
        const maxAvailableWidth = parentDimensions.width * 0.5;
        const legendItemHeight = height + VERTICAL_PADDING * 2;
        const legendHeight = legendItemHeight * items.length + TOP_MARGIN;
        const scrollBarDimension = legendHeight > parentDimensions.height ? SCROLL_BAR_WIDTH : 0;
        const staticWidth = legend_table_1.GRID_COLOR_WIDTH + GRID_MARGIN * 2 + actionWidth + scrollBarDimension;
        const width = Number.isFinite(legendSize)
            ? Math.min(Math.max(legendSize, legendItemWidth * 0.3 + staticWidth), maxAvailableWidth)
            : Math.ceil(Math.min(legendItemWidth + staticWidth, maxAvailableWidth));
        return {
            height: legendHeight,
            width,
            margin,
            position: legendPosition,
            seriesWidth: Math.min(seriesWidth, (Number.isFinite(legendSize) ? legendSize : maxAvailableWidth) / 2),
        };
    }
    const visibleLinesNumber = Math.min(items.length + 1, HORIZONTAL_VISIBLE_LINES_NUMBER);
    const singleLineHeight = height + GRID_CELL_PADDING.height * 2 + GRID_CELL_BORDER_WIDTH;
    return {
        height: singleLineHeight * visibleLinesNumber + GRID_MARGIN,
        width: Math.floor(Math.min(legendItemWidth + spacingBuffer + actionWidth, verticalWidth)),
        margin,
        position: legendPosition,
    };
}
//# sourceMappingURL=get_legend_table_size.js.map